/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.bolt;

import java.util.Map;
import org.apache.storm.mqtt.MqttMessage;
import org.apache.storm.mqtt.MqttTupleMapper;
import org.apache.storm.mqtt.common.MqttOptions;
import org.apache.storm.mqtt.common.MqttPublisher;
import org.apache.storm.mqtt.common.SslUtils;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttBolt
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttBolt.class);
    private MqttTupleMapper mapper;
    private transient MqttPublisher publisher;
    private boolean retain = false;
    private transient OutputCollector collector;
    private MqttOptions options;
    private KeyStoreLoader keyStoreLoader;
    private transient String topologyName;

    public MqttBolt(MqttOptions options, MqttTupleMapper mapper) {
        this(options, mapper, null, false);
    }

    public MqttBolt(MqttOptions options, MqttTupleMapper mapper, boolean retain) {
        this(options, mapper, null, retain);
    }

    public MqttBolt(MqttOptions options, MqttTupleMapper mapper, KeyStoreLoader keyStoreLoader) {
        this(options, mapper, keyStoreLoader, false);
    }

    public MqttBolt(MqttOptions options, MqttTupleMapper mapper, KeyStoreLoader keyStoreLoader, boolean retain) {
        this.options = options;
        this.mapper = mapper;
        this.retain = retain;
        this.keyStoreLoader = keyStoreLoader;
        SslUtils.checkSslConfig(this.options.getUrl(), keyStoreLoader);
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.topologyName = (String)conf.get("topology.name");
        this.publisher = new MqttPublisher(this.options, this.keyStoreLoader, this.retain);
        try {
            this.publisher.connectMqtt(this.topologyName + "-" + context.getThisComponentId() + "-" + context.getThisTaskId());
        }
        catch (Exception e) {
            LOG.error("Unable to connect to MQTT Broker.", e);
            throw new RuntimeException("Unable to connect to MQTT Broker.", e);
        }
    }

    protected void process(Tuple input) {
        MqttMessage message = this.mapper.toMessage((ITuple)input);
        try {
            this.publisher.publish(message);
            this.collector.ack(input);
        }
        catch (Exception e) {
            LOG.warn("Error publishing MQTT message. Failing tuple.", e);
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

