/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubQueueSelectorCacheBroker
extends BrokerFilter
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SubQueueSelectorCacheBroker.class);
    private ConcurrentHashMap<String, String> subSelectorCache = new ConcurrentHashMap();
    private final File persistFile;
    private boolean running = true;
    private Thread persistThread;
    private static final long MAX_PERSIST_INTERVAL = 600000L;
    private static final String SELECTOR_CACHE_PERSIST_THREAD_NAME = "SelectorCachePersistThread";

    public SubQueueSelectorCacheBroker(Broker next, File persistFile) {
        super(next);
        this.persistFile = persistFile;
        LOG.info("Using persisted selector cache from[{}]", (Object)persistFile);
        this.readCache();
        this.persistThread = new Thread((Runnable)this, SELECTOR_CACHE_PERSIST_THREAD_NAME);
        this.persistThread.start();
    }

    @Override
    public void stop() throws Exception {
        this.running = false;
        if (this.persistThread != null) {
            this.persistThread.interrupt();
            this.persistThread.join();
        }
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        LOG.debug("Caching consumer selector [{}] on a {}", (Object)info.getSelector(), (Object)info.getDestination().getQualifiedName());
        String selector = info.getSelector();
        if (selector == null) {
            selector = "TRUE";
        }
        this.subSelectorCache.put(info.getDestination().getQualifiedName(), selector);
        return super.addConsumer(context, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCache() {
        if (this.persistFile != null && this.persistFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.persistFile);
                try {
                    ObjectInputStream in = new ObjectInputStream(fis);
                    try {
                        this.subSelectorCache = (ConcurrentHashMap)in.readObject();
                    }
                    catch (ClassNotFoundException ex) {
                        LOG.error("Invalid selector cache data found. Please remove file.", ex);
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Unable to read persisted selector cache...it will be ignored!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCache() {
        LOG.debug("Persisting selector cache....");
        try {
            FileOutputStream fos = new FileOutputStream(this.persistFile);
            try {
                ObjectOutputStream out = new ObjectOutputStream(fos);
                try {
                    out.writeObject(this.subSelectorCache);
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Unable to persist selector cache", ex);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to access file[{}]", (Object)this.persistFile, (Object)ex);
        }
    }

    public String getSelector(String destination) {
        return this.subSelectorCache.get(destination);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.persistCache();
        }
    }
}

