/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.topology;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.jdbc.bolt.JdbcInsertBolt;
import org.apache.storm.jdbc.bolt.JdbcLookupBolt;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.mapper.JdbcMapper;
import org.apache.storm.jdbc.mapper.SimpleJdbcMapper;
import org.apache.storm.jdbc.topology.AbstractUserTopology;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;

public class UserPersistanceTopology
extends AbstractUserTopology {
    private static final String USER_SPOUT = "USER_SPOUT";
    private static final String LOOKUP_BOLT = "LOOKUP_BOLT";
    private static final String PERSISTANCE_BOLT = "PERSISTANCE_BOLT";

    public static void main(String[] args) throws Exception {
        new UserPersistanceTopology().execute(args);
    }

    @Override
    public StormTopology getTopology() {
        JdbcLookupBolt departmentLookupBolt = new JdbcLookupBolt(this.connectionProvider, "select dept_name from department, user_department where department.dept_id = user_department.dept_id and user_department.user_id = ?", this.jdbcLookupMapper);
        ArrayList schemaColumns = Lists.newArrayList((Object[])new Column[]{new Column("create_date", 91), new Column("dept_name", 12), new Column("user_id", 4), new Column("user_name", 12)});
        SimpleJdbcMapper mapper = new SimpleJdbcMapper((List)schemaColumns);
        JdbcInsertBolt userPersistanceBolt = new JdbcInsertBolt(this.connectionProvider, (JdbcMapper)mapper).withInsertQuery("insert into user (create_date, dept_name, user_id, user_name) values (?,?,?,?)");
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(USER_SPOUT, (IRichSpout)this.userSpout, (Number)1);
        builder.setBolt(LOOKUP_BOLT, (IRichBolt)departmentLookupBolt, (Number)1).shuffleGrouping(USER_SPOUT);
        builder.setBolt(PERSISTANCE_BOLT, (IRichBolt)userPersistanceBolt, (Number)1).shuffleGrouping(LOOKUP_BOLT);
        return builder.createTopology();
    }
}

