/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.HikariCPConnectionProvider;
import org.apache.storm.jdbc.common.JdbcClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcClientTest {
    private JdbcClient client;
    private static final String tableName = "user_details";

    @Before
    public void setup() {
        HashMap map = Maps.newHashMap();
        map.put("dataSourceClassName", "org.hsqldb.jdbc.JDBCDataSource");
        map.put("dataSource.url", "jdbc:hsqldb:mem:test");
        map.put("dataSource.user", "SA");
        map.put("dataSource.password", "");
        HikariCPConnectionProvider connectionProvider = new HikariCPConnectionProvider((Map)map);
        connectionProvider.prepare();
        int queryTimeoutSecs = 60;
        this.client = new JdbcClient((ConnectionProvider)connectionProvider, queryTimeoutSecs);
        this.client.executeSql("create table user_details (id integer, user_name varchar(100), created_timestamp TIMESTAMP)");
    }

    @Test
    public void testInsertAndSelect() {
        List<Column> row1 = this.createRow(1, "bob");
        List<Column> row2 = this.createRow(2, "alice");
        ArrayList rows = Lists.newArrayList((Object[])new List[]{row1, row2});
        this.client.insert(tableName, (List)rows);
        List selectedRows = this.client.select("select * from user_details where id = ?", (List)Lists.newArrayList((Object[])new Column[]{new Column("id", (Object)1, 4)}));
        ArrayList expectedRows = Lists.newArrayList();
        expectedRows.add(row1);
        Assert.assertEquals((Object)expectedRows, (Object)selectedRows);
        List<Column> row3 = this.createRow(3, "frank");
        ArrayList<List<Column>> moreRows = new ArrayList<List<Column>>();
        moreRows.add(row3);
        this.client.executeInsertQuery("insert into user_details values(?,?,?)", moreRows);
        selectedRows = this.client.select("select * from user_details where id = ?", (List)Lists.newArrayList((Object[])new Column[]{new Column("id", (Object)3, 4)}));
        expectedRows = Lists.newArrayList();
        expectedRows.add(row3);
        Assert.assertEquals((Object)expectedRows, (Object)selectedRows);
        selectedRows = this.client.select("select * from user_details order by id", (List)Lists.newArrayList());
        rows.add(row3);
        Assert.assertEquals((Object)rows, (Object)selectedRows);
    }

    private List<Column> createRow(int id, String name) {
        return Lists.newArrayList((Object[])new Column[]{new Column("ID", (Object)id, 4), new Column("USER_NAME", (Object)name, 12), new Column("CREATED_TIMESTAMP", (Object)new Timestamp(System.currentTimeMillis()), 93)});
    }

    @After
    public void cleanup() {
        this.client.executeSql("drop table user_details");
    }
}

