/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.bolt;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.jdbc.bolt.JdbcLookupBolt;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.HikariCPConnectionProvider;
import org.apache.storm.jdbc.mapper.JdbcLookupMapper;
import org.apache.storm.jdbc.mapper.SimpleJdbcLookupMapper;
import org.apache.storm.tuple.Fields;
import org.junit.Assert;
import org.junit.Test;

public class JdbcLookupBoltTest {
    @Test
    public void testValidation() {
        HikariCPConnectionProvider provider = new HikariCPConnectionProvider(new HashMap());
        SimpleJdbcLookupMapper mapper = new SimpleJdbcLookupMapper(new Fields(new String[]{"test"}), (List)Lists.newArrayList((Object[])new Column[]{new Column("test", 0)}));
        String selectQuery = "select * from dual";
        this.expectIllegaArgs(null, selectQuery, (JdbcLookupMapper)mapper);
        this.expectIllegaArgs((ConnectionProvider)provider, null, (JdbcLookupMapper)mapper);
        this.expectIllegaArgs((ConnectionProvider)provider, selectQuery, null);
    }

    private void expectIllegaArgs(ConnectionProvider provider, String selectQuery, JdbcLookupMapper mapper) {
        try {
            JdbcLookupBolt bolt = new JdbcLookupBolt(provider, selectQuery, mapper);
            Assert.fail((String)"Should have thrown IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

