/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.bolt;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.jdbc.bolt.JdbcInsertBolt;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.HikariCPConnectionProvider;
import org.apache.storm.jdbc.mapper.JdbcMapper;
import org.apache.storm.jdbc.mapper.SimpleJdbcMapper;
import org.junit.Assert;
import org.junit.Test;

public class JdbcInsertBoltTest {
    @Test
    public void testValidation() {
        JdbcInsertBolt bolt2;
        HikariCPConnectionProvider provider = new HikariCPConnectionProvider(new HashMap());
        SimpleJdbcMapper mapper = new SimpleJdbcMapper((List)Lists.newArrayList((Object[])new Column[]{new Column("test", 0)}));
        this.expectIllegaArgs(null, (JdbcMapper)mapper);
        this.expectIllegaArgs((ConnectionProvider)provider, null);
        try {
            bolt2 = new JdbcInsertBolt((ConnectionProvider)provider, (JdbcMapper)mapper);
            bolt2.withInsertQuery("test");
            bolt2.withTableName("test");
            Assert.fail((String)"Should have thrown IllegalArgumentException.");
        }
        catch (IllegalArgumentException bolt2) {
            // empty catch block
        }
        try {
            bolt2 = new JdbcInsertBolt((ConnectionProvider)provider, (JdbcMapper)mapper);
            bolt2.withTableName("test");
            bolt2.withInsertQuery("test");
            Assert.fail((String)"Should have thrown IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void expectIllegaArgs(ConnectionProvider provider, JdbcMapper mapper) {
        try {
            JdbcInsertBolt bolt = new JdbcInsertBolt(provider, mapper);
            Assert.fail((String)"Should have thrown IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

