/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.storm.sql.runtime.IOutputSerializer;

class JsonSerializer
implements IOutputSerializer {
    private final List<String> fieldNames;
    private final transient JsonFactory jsonFactory;

    JsonSerializer(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        this.jsonFactory = new JsonFactory();
    }

    public ByteBuffer write(List<Object> data, ByteBuffer buffer) {
        Preconditions.checkArgument((data != null && data.size() == this.fieldNames.size() ? 1 : 0) != 0, (Object)"Invalid schema");
        StringWriter sw = new StringWriter();
        try (JsonGenerator jg = this.jsonFactory.createGenerator((Writer)sw);){
            jg.writeStartObject();
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                jg.writeFieldName(this.fieldNames.get(i));
                jg.writeObject(data.get(i));
            }
            jg.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ByteBuffer.wrap(sw.toString().getBytes(StandardCharsets.UTF_8));
    }
}

