/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hdfs.common.rotation.MoveFileAction;
import org.apache.storm.hdfs.common.rotation.RotationAction;
import org.apache.storm.hdfs.trident.FixedBatchSpout;
import org.apache.storm.hdfs.trident.HdfsState;
import org.apache.storm.hdfs.trident.HdfsStateFactory;
import org.apache.storm.hdfs.trident.HdfsUpdater;
import org.apache.storm.hdfs.trident.format.DefaultFileNameFormat;
import org.apache.storm.hdfs.trident.format.DefaultSequenceFormat;
import org.apache.storm.hdfs.trident.format.FileNameFormat;
import org.apache.storm.hdfs.trident.format.SequenceFormat;
import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.FileSizeRotationPolicy;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.yaml.snakeyaml.Yaml;

public class TridentSequenceTopology {
    public static StormTopology buildTopology(String hdfsUrl) {
        FixedBatchSpout spout = new FixedBatchSpout(new Fields(new String[]{"sentence", "key"}), 1000, new List[]{new Values(new Object[]{"the cow jumped over the moon", 1L}), new Values(new Object[]{"the man went to the store and bought some candy", 2L}), new Values(new Object[]{"four score and seven years ago", 3L}), new Values(new Object[]{"how many apples can you eat", 4L}), new Values(new Object[]{"to be or not to be the person", 5L})});
        spout.setCycle(true);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("spout1", (IBatchSpout)spout);
        Fields hdfsFields = new Fields(new String[]{"sentence", "key"});
        DefaultFileNameFormat fileNameFormat = new DefaultFileNameFormat().withPath("/tmp/trident").withPrefix("trident").withExtension(".seq");
        FileSizeRotationPolicy rotationPolicy = new FileSizeRotationPolicy(5.0f, FileSizeRotationPolicy.Units.MB);
        HdfsState.SequenceFileOptions seqOpts = new HdfsState.SequenceFileOptions().withFileNameFormat((FileNameFormat)fileNameFormat).withSequenceFormat((SequenceFormat)new DefaultSequenceFormat("key", "sentence")).withRotationPolicy((FileRotationPolicy)rotationPolicy).withFsUrl(hdfsUrl).withConfigKey("hdfs.config").addRotationAction((RotationAction)new MoveFileAction().toDestination("/tmp/dest2/"));
        HdfsStateFactory factory = new HdfsStateFactory().withOptions((HdfsState.Options)seqOpts);
        TridentState state = stream.partitionPersist((StateFactory)factory, hdfsFields, (StateUpdater)new HdfsUpdater(), new Fields(new String[0]));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        Yaml yaml = new Yaml();
        FileInputStream in = new FileInputStream(args[1]);
        Map yamlConf = (Map)yaml.load((InputStream)in);
        ((InputStream)in).close();
        conf.put((Object)"hdfs.config", (Object)yamlConf);
        if (args.length == 2) {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("wordCounter", (Map)conf, TridentSequenceTopology.buildTopology(args[0]));
            Thread.sleep(120000L);
        } else if (args.length == 3) {
            conf.setNumWorkers(3);
            StormSubmitter.submitTopology((String)args[2], (Map)conf, (StormTopology)TridentSequenceTopology.buildTopology(args[0]));
        } else {
            System.out.println("Usage: TridentSequenceTopology [hdfs url] [hdfs yaml config file] <topology name>");
        }
    }
}

