/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.storm.hdfs.trident.HdfsState;
import org.apache.storm.hdfs.trident.format.DelimitedRecordFormat;
import org.apache.storm.hdfs.trident.format.FileNameFormat;
import org.apache.storm.hdfs.trident.format.RecordFormat;
import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.FileSizeRotationPolicy;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HdfsStateTest {
    private static final String TEST_OUT_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "trident-unit-test").toString();
    private static final String FILE_NAME_PREFIX = "hdfs-data-";
    private static final String TEST_TOPOLOGY_NAME = "test-topology";
    private static final String INDEX_FILE_PREFIX = ".index.";
    private final TestFileNameFormat fileNameFormat = new TestFileNameFormat();

    private HdfsState createHdfsState() {
        Fields hdfsFields = new Fields(new String[]{"f1"});
        DelimitedRecordFormat recordFormat = new DelimitedRecordFormat().withFields(hdfsFields);
        FileSizeRotationPolicy rotationPolicy = new FileSizeRotationPolicy(5.0f, FileSizeRotationPolicy.Units.MB);
        HdfsState.HdfsFileOptions options = new HdfsState.HdfsFileOptions().withFileNameFormat((FileNameFormat)this.fileNameFormat).withRecordFormat((RecordFormat)recordFormat).withRotationPolicy((FileRotationPolicy)rotationPolicy).withFsUrl("file://" + TEST_OUT_DIR);
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("topology.name", TEST_TOPOLOGY_NAME);
        HdfsState state = new HdfsState((HdfsState.Options)options);
        state.prepare(conf, null, 0, 1);
        return state;
    }

    private List<TridentTuple> createMockTridentTuples(int count) {
        TridentTuple tuple = (TridentTuple)Mockito.mock(TridentTuple.class);
        Mockito.when((Object)tuple.getValueByField((String)Matchers.any(String.class))).thenReturn((Object)"data");
        ArrayList<TridentTuple> tuples = new ArrayList<TridentTuple>();
        for (int i = 0; i < count; ++i) {
            tuples.add(tuple);
        }
        return tuples;
    }

    private List<String> getLinesFromCurrentDataFile() throws IOException {
        Path dataFile = Paths.get(TEST_OUT_DIR, this.fileNameFormat.getCurrentFileName());
        List<String> lines = Files.readAllLines(dataFile, Charset.defaultCharset());
        return lines;
    }

    @Before
    public void setUp() {
        FileUtils.deleteQuietly((File)new File(TEST_OUT_DIR));
    }

    @Test
    public void testPrepare() throws Exception {
        HdfsState state = this.createHdfsState();
        Collection files = FileUtils.listFiles((File)new File(TEST_OUT_DIR), null, (boolean)false);
        File hdfsDataFile = Paths.get(TEST_OUT_DIR, "hdfs-data-0").toFile();
        Assert.assertTrue((boolean)files.contains(hdfsDataFile));
    }

    @Test
    public void testIndexFileCreation() throws Exception {
        HdfsState state = this.createHdfsState();
        state.beginCommit(Long.valueOf(1L));
        Collection files = FileUtils.listFiles((File)new File(TEST_OUT_DIR), null, (boolean)false);
        File hdfsIndexFile = Paths.get(TEST_OUT_DIR, ".index.test-topology.0").toFile();
        Assert.assertTrue((boolean)files.contains(hdfsIndexFile));
    }

    @Test
    public void testUpdateState() throws Exception {
        HdfsState state = this.createHdfsState();
        state.beginCommit(Long.valueOf(1L));
        int tupleCount = 100;
        state.updateState(this.createMockTridentTuples(tupleCount), null);
        state.commit(Long.valueOf(1L));
        state.close();
        List<String> lines = this.getLinesFromCurrentDataFile();
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < tupleCount; ++i) {
            expected.add("data");
        }
        Assert.assertEquals((long)tupleCount, (long)lines.size());
        Assert.assertEquals(expected, lines);
    }

    @Test
    public void testRecoverOneBatch() throws Exception {
        HdfsState state = this.createHdfsState();
        state.beginCommit(Long.valueOf(1L));
        state.updateState(this.createMockTridentTuples(25), null);
        int replayBatchSize = 50;
        state.beginCommit(Long.valueOf(1L));
        state.updateState(this.createMockTridentTuples(replayBatchSize), null);
        state.commit(Long.valueOf(1L));
        state.close();
        List<String> lines = this.getLinesFromCurrentDataFile();
        Assert.assertEquals((long)replayBatchSize, (long)lines.size());
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < replayBatchSize; ++i) {
            expected.add("data");
        }
        Assert.assertEquals(expected, lines);
    }

    @Test
    public void testRecoverMultipleBatches() throws Exception {
        HdfsState state = this.createHdfsState();
        int batch1Count = 10;
        state.beginCommit(Long.valueOf(1L));
        state.updateState(this.createMockTridentTuples(batch1Count), null);
        state.commit(Long.valueOf(1L));
        int batch2Count = 20;
        state.beginCommit(Long.valueOf(2L));
        state.updateState(this.createMockTridentTuples(batch2Count), null);
        state.commit(Long.valueOf(2L));
        int batch3Count = 30;
        state.beginCommit(Long.valueOf(3L));
        state.updateState(this.createMockTridentTuples(batch3Count), null);
        state.commit(Long.valueOf(3L));
        int batch3ReplayCount = 40;
        state.beginCommit(Long.valueOf(3L));
        state.updateState(this.createMockTridentTuples(batch3ReplayCount), null);
        state.commit(Long.valueOf(3L));
        state.close();
        List<String> lines = this.getLinesFromCurrentDataFile();
        int preReplayCount = batch1Count + batch2Count + batch3Count;
        int expectedTupleCount = batch1Count + batch2Count + batch3ReplayCount;
        Assert.assertNotEquals((long)preReplayCount, (long)lines.size());
        Assert.assertEquals((long)expectedTupleCount, (long)lines.size());
    }

    private static class TestFileNameFormat
    implements FileNameFormat {
        private String currentFileName = "";

        private TestFileNameFormat() {
        }

        public void prepare(Map conf, int partitionIndex, int numPartitions) {
        }

        public String getName(long rotation, long timeStamp) {
            this.currentFileName = HdfsStateTest.FILE_NAME_PREFIX + Long.toString(rotation);
            return this.currentFileName;
        }

        public String getPath() {
            return TEST_OUT_DIR;
        }

        public String getCurrentFileName() {
            return this.currentFileName;
        }
    }
}

