/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.tuple.Fields;

public class FixedBatchSpout
implements IBatchSpout {
    Fields fields;
    List<Object>[] outputs;
    int maxBatchSize;
    HashMap<Long, List<List<Object>>> batches = new HashMap();
    int index = 0;
    boolean cycle = false;

    public FixedBatchSpout(Fields fields, int maxBatchSize, List<Object> ... outputs) {
        this.fields = fields;
        this.outputs = outputs;
        this.maxBatchSize = maxBatchSize;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public void open(Map conf, TopologyContext context) {
        this.index = 0;
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        List<List<Object>> batch = this.batches.get(batchId);
        if (batch == null) {
            batch = new ArrayList<List<Object>>();
            if (this.index >= this.outputs.length && this.cycle) {
                this.index = 0;
            }
            for (int i = 0; i < this.maxBatchSize; ++i) {
                if (this.index == this.outputs.length) {
                    this.index = 0;
                }
                batch.add(this.outputs[this.index]);
                ++this.index;
            }
            this.batches.put(batchId, batch);
        }
        for (List<Object> list : batch) {
            collector.emit(list);
        }
    }

    public void ack(long batchId) {
        this.batches.remove(batchId);
    }

    public void close() {
    }

    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.setMaxTaskParallelism(1);
        return conf;
    }

    public Fields getOutputFields() {
        return this.fields;
    }
}

