/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.storm.hdfs.spout.FileOffset;
import org.apache.storm.hdfs.spout.ProgressTracker;
import org.apache.storm.hdfs.spout.TextFileReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestProgressTracker {
    private FileSystem fs;
    private Configuration conf = new Configuration();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    public File baseFolder;

    @Before
    public void setUp() throws Exception {
        this.fs = FileSystem.getLocal((Configuration)this.conf);
    }

    @Test
    public void testBasic() throws Exception {
        ProgressTracker tracker = new ProgressTracker();
        this.baseFolder = this.tempFolder.newFolder("trackertest");
        Path file = new Path(this.baseFolder.toString() + "/" + "testHeadTrimming.txt");
        this.createTextFile(file, 10);
        TextFileReader reader = new TextFileReader(this.fs, file, null);
        FileOffset pos0 = tracker.getCommitPosition();
        Assert.assertNull((Object)pos0);
        TextFileReader.Offset currOffset = reader.getFileOffset();
        Assert.assertNotNull((Object)currOffset);
        Assert.assertEquals((long)0L, (long)currOffset.charOffset);
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos1 = reader.getFileOffset();
        tracker.recordAckedOffset((FileOffset)pos1);
        TextFileReader.Offset pos1b = (TextFileReader.Offset)tracker.getCommitPosition();
        Assert.assertEquals((Object)pos1, (Object)pos1b);
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos2 = reader.getFileOffset();
        tracker.recordAckedOffset((FileOffset)pos2);
        tracker.dumpState(System.err);
        TextFileReader.Offset pos2b = (TextFileReader.Offset)tracker.getCommitPosition();
        Assert.assertEquals((Object)pos2, (Object)pos2b);
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos3 = reader.getFileOffset();
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos4 = reader.getFileOffset();
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos5 = reader.getFileOffset();
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos6 = reader.getFileOffset();
        Assert.assertNotNull((Object)reader.next());
        TextFileReader.Offset pos7 = reader.getFileOffset();
        tracker.recordAckedOffset((FileOffset)pos5);
        Assert.assertEquals((Object)pos2, (Object)tracker.getCommitPosition());
        tracker.recordAckedOffset((FileOffset)pos4);
        Assert.assertEquals((Object)pos2, (Object)tracker.getCommitPosition());
        tracker.recordAckedOffset((FileOffset)pos3);
        Assert.assertEquals((Object)pos5, (Object)tracker.getCommitPosition());
        tracker.recordAckedOffset((FileOffset)pos6);
        Assert.assertEquals((Object)pos6, (Object)tracker.getCommitPosition());
        tracker.recordAckedOffset((FileOffset)pos6);
        Assert.assertEquals((Object)pos6, (Object)tracker.getCommitPosition());
        tracker.recordAckedOffset((FileOffset)pos7);
        Assert.assertEquals((Object)pos7, (Object)tracker.getCommitPosition());
        tracker.dumpState(System.err);
    }

    private void createTextFile(Path file, int lineCount) throws IOException {
        FSDataOutputStream os = this.fs.create(file);
        for (int i = 0; i < lineCount; ++i) {
            os.writeBytes("line " + i + System.lineSeparator());
        }
        os.close();
    }
}

