/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.storm.hdfs.common.HdfsUtils;
import org.apache.storm.hdfs.spout.FileLock;
import org.apache.storm.hdfs.spout.FileReader;
import org.apache.storm.hdfs.spout.HdfsSpout;
import org.apache.storm.hdfs.spout.ParseException;
import org.apache.storm.hdfs.spout.SequenceFileReader;
import org.apache.storm.hdfs.spout.TestFileLock;
import org.apache.storm.hdfs.spout.TextFileReader;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class TestHdfsSpout {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    public File baseFolder;
    private Path source;
    private Path archive;
    private Path badfiles;
    static MiniDFSCluster.Builder builder;
    static MiniDFSCluster hdfsCluster;
    static DistributedFileSystem fs;
    static String hdfsURI;
    static Configuration conf;

    @BeforeClass
    public static void setupClass() throws IOException {
        builder = new MiniDFSCluster.Builder(new Configuration());
        hdfsCluster = builder.build();
        fs = hdfsCluster.getFileSystem();
        hdfsURI = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/";
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        fs.close();
        hdfsCluster.shutdown();
    }

    @Before
    public void setup() throws Exception {
        this.baseFolder = this.tempFolder.newFolder("hdfsspout");
        this.source = new Path(this.baseFolder.toString() + "/source");
        fs.mkdirs(this.source);
        this.archive = new Path(this.baseFolder.toString() + "/archive");
        fs.mkdirs(this.archive);
        this.badfiles = new Path(this.baseFolder.toString() + "/bad");
        fs.mkdirs(this.badfiles);
    }

    @After
    public void shutDown() throws IOException {
        fs.delete(new Path(this.baseFolder.toString()), true);
    }

    @Test
    public void testSimpleText_noACK() throws IOException {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 5);
        Path file2 = new Path(this.source.toString() + "/file2.txt");
        this.createTextFile(file2, 5);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "1");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        this.runSpout(spout, "r11");
        Path arc1 = new Path(this.archive.toString() + "/file1.txt");
        Path arc2 = new Path(this.archive.toString() + "/file2.txt");
        this.checkCollectorOutput_txt((MockCollector)spout.getCollector(), arc1, arc2);
    }

    @Test
    public void testSimpleText_ACK() throws IOException {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 5);
        Path file2 = new Path(this.source.toString() + "/file2.txt");
        this.createTextFile(file2, 5);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "1");
        conf.put("topology.acker.executors", "1");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        this.runSpout(spout, "r6", "a0", "a1", "a2", "a3", "a4");
        Path arc1 = new Path(this.archive.toString() + "/file1.txt");
        this.checkCollectorOutput_txt((MockCollector)spout.getCollector(), arc1);
        this.runSpout(spout, "r6", "a5", "a6", "a7", "a8", "a9");
        Path arc2 = new Path(this.archive.toString() + "/file2.txt");
        this.checkCollectorOutput_txt((MockCollector)spout.getCollector(), arc1, arc2);
    }

    @Test
    public void testResumeAbandoned_Text_NoAck() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 6);
        Integer lockExpirySec = 1;
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "1000");
        conf.put("hdfsspout.lock.timeout.sec", lockExpirySec.toString());
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        HdfsSpout spout2 = TestHdfsSpout.makeSpout(1, conf, "text", TextFileReader.defaultFields);
        List<String> res = this.runSpout(spout, "r2");
        Assert.assertEquals((long)2L, (long)res.size());
        FileLock lock = (FileLock)TestHdfsSpout.getField(spout, "lock");
        TestFileLock.closeUnderlyingLockFile(lock);
        Thread.sleep(lockExpirySec * 2 * 1000);
        Assert.assertTrue((boolean)fs.exists(lock.getLockFile()));
        List<String> res2 = this.runSpout(spout2, "r3");
        Assert.assertEquals((long)3L, (long)res2.size());
        Assert.assertTrue((boolean)fs.exists(lock.getLockFile()));
        List<String> contents = TestHdfsSpout.readTextFile((FileSystem)fs, lock.getLockFile().toString());
        Assert.assertFalse((boolean)contents.isEmpty());
        res2 = this.runSpout(spout2, "r2");
        Assert.assertEquals((long)4L, (long)res2.size());
        Assert.assertFalse((boolean)fs.exists(lock.getLockFile()));
        FileReader rdr = (FileReader)TestHdfsSpout.getField(spout2, "reader");
        Assert.assertNull((Object)rdr);
        Assert.assertTrue((boolean)TestHdfsSpout.getBoolField(spout2, "fileReadCompletely"));
    }

    @Test
    public void testResumeAbandoned_Seq_NoAck() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.seq");
        TestHdfsSpout.createSeqFile((FileSystem)fs, file1, 6);
        Integer lockExpirySec = 1;
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "1000");
        conf.put("hdfsspout.lock.timeout.sec", lockExpirySec.toString());
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "seq", SequenceFileReader.defaultFields);
        HdfsSpout spout2 = TestHdfsSpout.makeSpout(1, conf, "seq", SequenceFileReader.defaultFields);
        List<String> res = this.runSpout(spout, "r2");
        Assert.assertEquals((long)2L, (long)res.size());
        FileLock lock = (FileLock)TestHdfsSpout.getField(spout, "lock");
        TestFileLock.closeUnderlyingLockFile(lock);
        Thread.sleep(lockExpirySec * 2 * 1000);
        Assert.assertTrue((boolean)fs.exists(lock.getLockFile()));
        List<String> res2 = this.runSpout(spout2, "r3");
        Assert.assertEquals((long)3L, (long)res2.size());
        Assert.assertTrue((boolean)fs.exists(lock.getLockFile()));
        List<String> contents = this.getTextFileContents((FileSystem)fs, lock.getLockFile());
        Assert.assertFalse((boolean)contents.isEmpty());
        res2 = this.runSpout(spout2, "r3");
        Assert.assertEquals((long)4L, (long)res2.size());
        Assert.assertFalse((boolean)fs.exists(lock.getLockFile()));
        FileReader rdr = (FileReader)TestHdfsSpout.getField(spout2, "reader");
        Assert.assertNull((Object)rdr);
        Assert.assertTrue((boolean)TestHdfsSpout.getBoolField(spout2, "fileReadCompletely"));
    }

    private void checkCollectorOutput_txt(MockCollector collector, Path ... txtFiles) throws IOException {
        ArrayList<String> expected = new ArrayList<String>();
        for (Path txtFile : txtFiles) {
            List<String> lines = this.getTextFileContents((FileSystem)fs, txtFile);
            expected.addAll(lines);
        }
        ArrayList<String> actual = new ArrayList<String>();
        for (HdfsUtils.Pair<HdfsSpout.MessageId, List<Object>> item : collector.items) {
            actual.add(((List)item.getValue()).get(0).toString());
        }
        Assert.assertEquals(expected, actual);
    }

    private List<String> getTextFileContents(FileSystem fs, Path txtFile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FSDataInputStream istream = fs.open(txtFile);
        InputStreamReader isreader = new InputStreamReader((InputStream)istream, "UTF-8");
        BufferedReader reader = new BufferedReader(isreader);
        String line = reader.readLine();
        while (line != null) {
            result.add(line);
            line = reader.readLine();
        }
        isreader.close();
        return result;
    }

    private void checkCollectorOutput_seq(MockCollector collector, Path ... seqFiles) throws IOException {
        ArrayList<String> expected = new ArrayList<String>();
        for (Path seqFile : seqFiles) {
            List<String> lines = this.getSeqFileContents((FileSystem)fs, seqFile);
            expected.addAll(lines);
        }
        Assert.assertTrue((boolean)expected.equals(collector.lines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSeqFileContents(FileSystem fs, Path ... seqFiles) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (Path seqFile : seqFiles) {
            Path file = new Path(fs.getUri().toString() + seqFile.toString());
            try (SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});){
                Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                while (reader.next(key, value)) {
                    String keyValStr = Arrays.asList(key, value).toString();
                    result.add(keyValStr);
                }
            }
        }
        return result;
    }

    private List<String> listDir(Path p) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        RemoteIterator fileNames = fs.listFiles(p, false);
        while (fileNames.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileNames.next();
            result.add(Path.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath()).toString());
        }
        return result;
    }

    @Test
    public void testMultipleFileConsumption_Ack() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 5);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "1");
        conf.put("topology.acker.executors", "1");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        this.runSpout(spout, "r3");
        FileReader reader = (FileReader)TestHdfsSpout.getField(spout, "reader");
        Assert.assertNotNull((Object)reader);
        Assert.assertEquals((Object)false, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        this.runSpout(spout, "r3");
        reader = (FileReader)TestHdfsSpout.getField(spout, "reader");
        Assert.assertNotNull((Object)reader);
        Assert.assertEquals((Object)true, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        this.runSpout(spout, "a0", "a1", "a2");
        reader = (FileReader)TestHdfsSpout.getField(spout, "reader");
        Assert.assertNotNull((Object)reader);
        Assert.assertEquals((Object)true, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        this.runSpout(spout, "a3", "a4");
        reader = (FileReader)TestHdfsSpout.getField(spout, "reader");
        Assert.assertNull((Object)reader);
        Assert.assertEquals((Object)true, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        Path file2 = new Path(this.source.toString() + "/file2.txt");
        this.createTextFile(file2, 5);
        this.runSpout(spout, "r1");
        Assert.assertNotNull(TestHdfsSpout.getField(spout, "reader"));
        Assert.assertEquals((Object)false, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        this.runSpout(spout, "a5");
        Assert.assertNotNull(TestHdfsSpout.getField(spout, "reader"));
        Assert.assertEquals((Object)false, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
        this.runSpout(spout, "r5", "a6", "a7", "a8", "a9");
        Assert.assertNull(TestHdfsSpout.getField(spout, "reader"));
        Assert.assertEquals((Object)true, (Object)TestHdfsSpout.getBoolField(spout, "fileReadCompletely"));
    }

    private static <T> T getField(HdfsSpout spout, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field readerFld = HdfsSpout.class.getDeclaredField(fieldName);
        readerFld.setAccessible(true);
        return (T)readerFld.get(spout);
    }

    private static boolean getBoolField(HdfsSpout spout, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field readerFld = HdfsSpout.class.getDeclaredField(fieldName);
        readerFld.setAccessible(true);
        return readerFld.getBoolean(spout);
    }

    @Test
    public void testSimpleSequenceFile() throws IOException {
        this.source = new Path("/tmp/hdfsspout/source");
        fs.mkdirs(this.source);
        this.archive = new Path("/tmp/hdfsspout/archive");
        fs.mkdirs(this.archive);
        Path file1 = new Path(this.source + "/file1.seq");
        TestHdfsSpout.createSeqFile((FileSystem)fs, file1, 5);
        Path file2 = new Path(this.source + "/file2.seq");
        TestHdfsSpout.createSeqFile((FileSystem)fs, file2, 5);
        Map conf = this.getDefaultConfig();
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "seq", SequenceFileReader.defaultFields);
        List<String> res = this.runSpout(spout, "r11");
        Assert.assertEquals((long)10L, (long)res.size());
        Assert.assertEquals((long)2L, (long)this.listDir(this.archive).size());
        Path f1 = new Path(this.archive + "/file1.seq");
        Path f2 = new Path(this.archive + "/file2.seq");
        this.checkCollectorOutput_seq((MockCollector)spout.getCollector(), f1, f2);
    }

    @Test
    public void testReadFailures() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        Path file2 = new Path(this.source.toString() + "/file2.txt");
        this.createTextFile(file1, 6);
        this.createTextFile(file2, 7);
        Assert.assertEquals((long)2L, (long)this.listDir(this.source).size());
        Map conf = this.getDefaultConfig();
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, MockTextFailingReader.class.getName(), MockTextFailingReader.defaultFields);
        List<String> res = this.runSpout(spout, "r11");
        Object[] expected = new String[]{"[line 0]", "[line 1]", "[line 2]", "[line 0]", "[line 1]", "[line 2]"};
        Assert.assertArrayEquals((Object[])expected, (Object[])res.toArray());
        Assert.assertEquals((long)((MockCollector)spout.getCollector()).lines.size(), (long)6L);
        ArrayList badFiles = HdfsUtils.listFilesByModificationTime((FileSystem)fs, (Path)this.badfiles, (long)0L);
        Assert.assertEquals((long)badFiles.size(), (long)2L);
    }

    @Test
    public void testLocking() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 10);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "1");
        conf.put("hdfsspout.commit.sec", "100");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        List<String> res = this.runSpout(spout, "r5");
        Assert.assertEquals((long)5L, (long)res.size());
        List<String> lockFiles = this.listDir(spout.getLockDirPath());
        Assert.assertEquals((long)1L, (long)lockFiles.size());
        List<String> lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFiles.get(0));
        Assert.assertEquals((long)lines.size(), (long)(res.size() + 1));
        this.runSpout(spout, "r6");
        lockFiles = this.listDir(spout.getLockDirPath());
        Assert.assertEquals((long)0L, (long)lockFiles.size());
        Path file2 = new Path(this.source.toString() + "/file2.txt");
        this.createTextFile(file2, 10);
        res = this.runSpout(spout, "r5");
        Assert.assertEquals((long)15L, (long)res.size());
        lockFiles = this.listDir(spout.getLockDirPath());
        Assert.assertEquals((long)1L, (long)lockFiles.size());
        lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFiles.get(0));
        Assert.assertEquals((long)6L, (long)lines.size());
        this.runSpout(spout, "r6");
        lockFiles = this.listDir(spout.getLockDirPath());
        Assert.assertEquals((long)0L, (long)lockFiles.size());
    }

    @Test
    public void testLockLoggingFreqCount() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 10);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "2");
        conf.put("hdfsspout.commit.sec", "1000");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        this.runSpout(spout, "r5");
        String lockFile = this.listDir(spout.getLockDirPath()).get(0);
        List<String> lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFile);
        Assert.assertEquals((long)lines.size(), (long)3L);
        this.runSpout(spout, "r1");
        lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFile);
        Assert.assertEquals((long)lines.size(), (long)4L);
    }

    @Test
    public void testLockLoggingFreqSec() throws Exception {
        Path file1 = new Path(this.source.toString() + "/file1.txt");
        this.createTextFile(file1, 10);
        Map conf = this.getDefaultConfig();
        conf.put("hdfsspout.commit.count", "0");
        conf.put("hdfsspout.commit.sec", "2");
        HdfsSpout spout = TestHdfsSpout.makeSpout(0, conf, "text", TextFileReader.defaultFields);
        this.runSpout(spout, "r5");
        String lockFile = this.listDir(spout.getLockDirPath()).get(0);
        List<String> lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFile);
        Assert.assertEquals((long)lines.size(), (long)1L);
        Thread.sleep(3000L);
        this.runSpout(spout, "r1");
        lines = TestHdfsSpout.readTextFile((FileSystem)fs, lockFile);
        Assert.assertEquals((long)2L, (long)lines.size());
    }

    private static List<String> readTextFile(FileSystem fs, String f) throws IOException {
        Path file = new Path(f);
        FSDataInputStream x = fs.open(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)x));
        String line = null;
        ArrayList<String> result = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    private Map getDefaultConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("hdfsspout.source.dir", this.source.toString());
        conf.put("hdfsspout.archive.dir", this.archive.toString());
        conf.put("hdfsspout.badfiles.dir", this.badfiles.toString());
        conf.put("hdfsspout.hdfs", hdfsCluster.getURI().toString());
        conf.put("topology.acker.executors", "0");
        return conf;
    }

    private static HdfsSpout makeSpout(int spoutId, Map conf, String readerType, String[] outputFields) {
        HdfsSpout spout = new HdfsSpout().withOutputFields(outputFields);
        MockCollector collector = new MockCollector();
        conf.put("hdfsspout.reader.type", readerType);
        spout.open(conf, (TopologyContext)new MockTopologyContext(spoutId), (SpoutOutputCollector)collector);
        conf.put("hdfsspout.hdfs", hdfsCluster.getURI().toString());
        return spout;
    }

    private List<String> runSpout(HdfsSpout spout, String ... cmds) {
        MockCollector collector = (MockCollector)spout.getCollector();
        for (String cmd : cmds) {
            int n;
            if (cmd.startsWith("r")) {
                int count = 1;
                if (cmd.length() > 1) {
                    count = Integer.parseInt(cmd.substring(1));
                }
                for (int i = 0; i < count; ++i) {
                    spout.nextTuple();
                }
                continue;
            }
            if (cmd.startsWith("a")) {
                n = Integer.parseInt(cmd.substring(1));
                HdfsUtils.Pair<HdfsSpout.MessageId, List<Object>> item = collector.items.get(n);
                spout.ack(item.getKey());
                continue;
            }
            if (!cmd.startsWith("f")) continue;
            n = Integer.parseInt(cmd.substring(1));
            HdfsUtils.Pair<HdfsSpout.MessageId, List<Object>> item = collector.items.get(n);
            spout.fail(item.getKey());
        }
        return collector.lines;
    }

    private void createTextFile(Path file, int lineCount) throws IOException {
        FSDataOutputStream os = fs.create(file);
        int size = 0;
        for (int i = 0; i < lineCount; ++i) {
            os.writeBytes("line " + i + System.lineSeparator());
            String msg = "line " + i + System.lineSeparator();
            size += msg.getBytes().length;
        }
        os.close();
    }

    private static void createSeqFile(FileSystem fs, Path file, int rowCount) throws IOException {
        Configuration conf = new Configuration();
        try {
            if (fs.exists(file)) {
                fs.delete(file, false);
            }
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, IntWritable.class, Text.class);
            for (int i = 0; i < rowCount; ++i) {
                w.append((Writable)new IntWritable(i), (Writable)new Text("line " + i));
            }
            w.close();
            System.out.println("done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        conf = new Configuration();
    }

    static class MockTopologyContext
    extends TopologyContext {
        private final int componentId;

        public MockTopologyContext(int componentId) {
            super(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            this.componentId = componentId;
        }

        public String getThisComponentId() {
            return Integer.toString(this.componentId);
        }
    }

    static class MockTextFailingReader
    extends TextFileReader {
        public static final String[] defaultFields = new String[]{"line"};
        int readAttempts = 0;

        public MockTextFailingReader(FileSystem fs, Path file, Map conf) throws IOException {
            super(fs, file, conf);
        }

        public List<Object> next() throws IOException, ParseException {
            ++this.readAttempts;
            if (this.readAttempts == 3 || this.readAttempts == 4) {
                throw new IOException("mock test exception");
            }
            if (this.readAttempts > 5) {
                throw new ParseException("mock test exception", null);
            }
            return super.next();
        }
    }

    static class MockCollector
    extends SpoutOutputCollector {
        public ArrayList<String> lines = new ArrayList();
        public ArrayList<HdfsUtils.Pair<HdfsSpout.MessageId, List<Object>>> items = new ArrayList();

        public MockCollector() {
            super(null);
        }

        public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
            this.lines.add(tuple.toString());
            this.items.add((HdfsUtils.Pair<HdfsSpout.MessageId, List<Object>>)HdfsUtils.Pair.of((Object)messageId, tuple));
            return null;
        }

        public void emitDirect(int arg0, String arg1, List<Object> arg2, Object arg3) {
            throw new NotImplementedException();
        }

        public void reportError(Throwable arg0) {
            throw new NotImplementedException();
        }

        public long getPendingCount() {
            return 0L;
        }
    }
}

