/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHdfsSemantics {
    static MiniDFSCluster.Builder builder;
    static MiniDFSCluster hdfsCluster;
    static FileSystem fs;
    static String hdfsURI;
    static HdfsConfiguration conf;
    private Path dir = new Path("/tmp/filesdir");

    @BeforeClass
    public static void setupClass() throws IOException {
        conf.set("ipc.ping.interval", "5000");
        builder = new MiniDFSCluster.Builder(new Configuration());
        hdfsCluster = builder.build();
        fs = hdfsCluster.getFileSystem();
        hdfsURI = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/";
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        fs.close();
        hdfsCluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        assert (fs.mkdirs(this.dir));
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(this.dir, true);
    }

    @Test
    public void testDeleteSemantics() throws Exception {
        Path file = new Path(this.dir.toString() + '/' + "file1");
        Assert.assertFalse((boolean)fs.exists(file));
        try {
            Assert.assertFalse((boolean)fs.delete(file, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fs.create(file, false);
        Assert.assertTrue((boolean)fs.delete(file, false));
        FSDataOutputStream os = fs.create(file, false);
        os.close();
        Assert.assertTrue((boolean)fs.exists(file));
        Assert.assertTrue((boolean)fs.delete(file, false));
        Assert.assertFalse((boolean)fs.exists(file));
    }

    @Test
    public void testConcurrentDeletion() throws Exception {
        Path file = new Path(this.dir.toString() + '/' + "file1");
        fs.create(file).close();
        FileDeletionThread[] thds = this.startThreads(10, file);
        int successCount = 0;
        for (FileDeletionThread thd : thds) {
            thd.join();
            if (thd.succeeded) {
                ++successCount;
            }
            if (thd.exception == null) continue;
            Assert.assertNotNull((Object)thd.exception);
        }
        System.err.println(successCount);
        Assert.assertEquals((long)1L, (long)successCount);
    }

    @Test
    public void testAppendSemantics() throws Exception {
        Path file1 = new Path(this.dir.toString() + '/' + "file1");
        FSDataOutputStream os1 = fs.create(file1, false);
        try {
            fs.append(file1);
            Assert.assertTrue((String)"Append did not throw an exception", (boolean)false);
        }
        catch (RemoteException e) {
            Assert.assertEquals(AlreadyBeingCreatedException.class, e.unwrapRemoteException().getClass());
        }
        os1.close();
        FSDataOutputStream os2 = fs.append(file1);
        os2.close();
    }

    @Test
    public void testDoubleCreateSemantics() throws Exception {
        Path file1 = new Path(this.dir.toString() + '/' + "file1");
        FSDataOutputStream os1 = fs.create(file1, false);
        try {
            fs.create(file1, false);
            Assert.assertTrue((String)"Create did not throw an exception", (boolean)false);
        }
        catch (RemoteException e) {
            Assert.assertEquals(AlreadyBeingCreatedException.class, e.unwrapRemoteException().getClass());
        }
        os1.close();
        try {
            fs.create(file1, false);
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
        fs.delete(file1, false);
        FSDataOutputStream os2 = fs.create(file1, false);
        Assert.assertNotNull((Object)os2);
        os2.close();
    }

    private FileDeletionThread[] startThreads(int thdCount, Path file) throws IOException {
        FileDeletionThread[] result = new FileDeletionThread[thdCount];
        for (int i = 0; i < thdCount; ++i) {
            result[i] = new FileDeletionThread(i, fs, file);
        }
        for (FileDeletionThread thd : result) {
            thd.start();
        }
        return result;
    }

    static {
        conf = new HdfsConfiguration();
    }

    private static class FileDeletionThread
    extends Thread {
        private final int thdNum;
        private final FileSystem fs;
        private final Path file;
        public boolean succeeded;
        public Exception exception = null;

        public FileDeletionThread(int thdNum, FileSystem fs, Path file) throws IOException {
            this.thdNum = thdNum;
            this.fs = fs;
            this.file = file;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("FileDeletionThread-" + this.thdNum);
            try {
                this.succeeded = this.fs.delete(this.file, false);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

