/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.storm.hdfs.common.HdfsUtils;
import org.apache.storm.hdfs.spout.FileLock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFileLock {
    static MiniDFSCluster.Builder builder;
    static MiniDFSCluster hdfsCluster;
    static FileSystem fs;
    static String hdfsURI;
    static HdfsConfiguration conf;
    private Path filesDir = new Path("/tmp/filesdir");
    private Path locksDir = new Path("/tmp/locskdir");

    @BeforeClass
    public static void setupClass() throws IOException {
        conf.set("ipc.ping.interval", "5000");
        builder = new MiniDFSCluster.Builder(new Configuration());
        hdfsCluster = builder.build();
        fs = hdfsCluster.getFileSystem();
        hdfsURI = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/";
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        fs.close();
        hdfsCluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        assert (fs.mkdirs(this.filesDir));
        assert (fs.mkdirs(this.locksDir));
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(this.filesDir, true);
        fs.delete(this.locksDir, true);
    }

    @Test
    public void testBasicLocking() throws Exception {
        Path file1 = new Path(this.filesDir + "/" + "file1");
        Path file2 = new Path(this.filesDir + "/" + "file2");
        fs.create(file1).close();
        fs.create(file2).close();
        FileLock lock1a = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        Assert.assertNotNull((Object)lock1a);
        Assert.assertTrue((boolean)fs.exists(lock1a.getLockFile()));
        Assert.assertEquals((Object)lock1a.getLockFile().getParent(), (Object)this.locksDir);
        Assert.assertEquals((Object)lock1a.getLockFile().getName(), (Object)file1.getName());
        FileLock lock1b = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        Assert.assertNull((Object)lock1b);
        lock1a.release();
        Assert.assertFalse((boolean)fs.exists(lock1a.getLockFile()));
        FileLock lock1c = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        Assert.assertNotNull((Object)lock1c);
        Assert.assertTrue((boolean)fs.exists(lock1c.getLockFile()));
        Assert.assertEquals((Object)lock1c.getLockFile().getParent(), (Object)this.locksDir);
        Assert.assertEquals((Object)lock1c.getLockFile().getName(), (Object)file1.getName());
        FileLock lock2a = FileLock.tryLock((FileSystem)fs, (Path)file2, (Path)this.locksDir, (String)"spout1");
        Assert.assertNotNull((Object)lock2a);
        Assert.assertTrue((boolean)fs.exists(lock2a.getLockFile()));
        Assert.assertEquals((Object)lock2a.getLockFile().getParent(), (Object)this.locksDir);
        Assert.assertEquals((Object)lock2a.getLockFile().getName(), (Object)file2.getName());
        lock2a.release();
        Assert.assertFalse((boolean)fs.exists(lock2a.getLockFile()));
        lock1c.release();
        Assert.assertFalse((boolean)fs.exists(lock1c.getLockFile()));
    }

    @Test
    public void testHeartbeat() throws Exception {
        Path file1 = new Path(this.filesDir + "/" + "file1");
        fs.create(file1).close();
        FileLock lock1 = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        Assert.assertNotNull((Object)lock1);
        Assert.assertTrue((boolean)fs.exists(lock1.getLockFile()));
        ArrayList<String> lines = this.readTextFile(lock1.getLockFile());
        Assert.assertEquals((String)"heartbeats appear to be missing", (long)1L, (long)lines.size());
        lock1.heartbeat("1");
        lock1.heartbeat("2");
        lock1.heartbeat("3");
        lines = this.readTextFile(lock1.getLockFile());
        Assert.assertEquals((String)"heartbeats appear to be missing", (long)4L, (long)lines.size());
        lock1.heartbeat("4");
        lock1.heartbeat("5");
        lock1.heartbeat("6");
        lines = this.readTextFile(lock1.getLockFile());
        Assert.assertEquals((String)"heartbeats appear to be missing", (long)7L, (long)lines.size());
        lock1.release();
        lines = this.readTextFile(lock1.getLockFile());
        Assert.assertNull(lines);
        Assert.assertFalse((boolean)fs.exists(lock1.getLockFile()));
    }

    @Test
    public void testConcurrentLocking() throws IOException, InterruptedException {
        FileLockingThread[] thds;
        Path file1 = new Path(this.filesDir + "/" + "file1");
        fs.create(file1).close();
        for (FileLockingThread thd : thds = this.startThreads(100, file1, this.locksDir)) {
            thd.join();
            if (!thd.cleanExit) {
                System.err.println(thd.getName() + " did not exit cleanly");
            }
            Assert.assertTrue((boolean)thd.cleanExit);
        }
        Path lockFile = new Path(this.locksDir + "/" + file1.getName());
        Assert.assertFalse((boolean)fs.exists(lockFile));
    }

    private FileLockingThread[] startThreads(int thdCount, Path fileToLock, Path locksDir) throws IOException {
        FileLockingThread[] result = new FileLockingThread[thdCount];
        for (int i = 0; i < thdCount; ++i) {
            result[i] = new FileLockingThread(i, fs, fileToLock, locksDir, "spout" + Integer.toString(i));
        }
        for (FileLockingThread thd : result) {
            thd.start();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaleLockDetection_SingleLock() throws Exception {
        boolean LOCK_EXPIRY_SEC = true;
        int WAIT_MSEC = 1500;
        Path file1 = new Path(this.filesDir + "/" + "file1");
        fs.create(file1).close();
        FileLock lock1 = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        try {
            Assert.assertNotNull((Object)lock1);
            Assert.assertTrue((boolean)fs.exists(lock1.getLockFile()));
            Thread.sleep(1500L);
            HdfsUtils.Pair expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNotNull((Object)expired);
            lock1.heartbeat("1");
            expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNull((Object)expired);
            FileLock.LogEntry lastEntry = lock1.getLastLogEntry();
            Assert.assertNotNull((Object)lastEntry);
            Assert.assertEquals((Object)"1", (Object)lastEntry.fileOffset);
            Thread.sleep(1500L);
            expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNotNull((Object)expired);
        }
        finally {
            lock1.release();
            fs.delete(file1, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaleLockDetection_MultipleLocks() throws Exception {
        boolean LOCK_EXPIRY_SEC = true;
        int WAIT_MSEC = 1500;
        Path file1 = new Path(this.filesDir + "/" + "file1");
        Path file2 = new Path(this.filesDir + "/" + "file2");
        Path file3 = new Path(this.filesDir + "/" + "file3");
        fs.create(file1).close();
        fs.create(file2).close();
        fs.create(file3).close();
        FileLock lock1 = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        FileLock lock2 = FileLock.tryLock((FileSystem)fs, (Path)file2, (Path)this.locksDir, (String)"spout2");
        FileLock lock3 = FileLock.tryLock((FileSystem)fs, (Path)file3, (Path)this.locksDir, (String)"spout3");
        Assert.assertNotNull((Object)lock1);
        Assert.assertNotNull((Object)lock2);
        Assert.assertNotNull((Object)lock3);
        try {
            HdfsUtils.Pair expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNull((Object)expired);
            Thread.sleep(1500L);
            lock1.heartbeat("1");
            lock2.heartbeat("1");
            expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNotNull((Object)expired);
            Assert.assertEquals((Object)"spout3", (Object)((FileLock.LogEntry)expired.getValue()).componentID);
        }
        finally {
            lock1.release();
            lock2.release();
            lock3.release();
            fs.delete(file1, false);
            fs.delete(file2, false);
            fs.delete(file3, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockRecovery() throws Exception {
        boolean LOCK_EXPIRY_SEC = true;
        int WAIT_MSEC = 1500;
        Path file1 = new Path(this.filesDir + "/" + "file1");
        Path file2 = new Path(this.filesDir + "/" + "file2");
        Path file3 = new Path(this.filesDir + "/" + "file3");
        fs.create(file1).close();
        fs.create(file2).close();
        fs.create(file3).close();
        FileLock lock1 = FileLock.tryLock((FileSystem)fs, (Path)file1, (Path)this.locksDir, (String)"spout1");
        FileLock lock2 = FileLock.tryLock((FileSystem)fs, (Path)file2, (Path)this.locksDir, (String)"spout2");
        FileLock lock3 = FileLock.tryLock((FileSystem)fs, (Path)file3, (Path)this.locksDir, (String)"spout3");
        Assert.assertNotNull((Object)lock1);
        Assert.assertNotNull((Object)lock2);
        Assert.assertNotNull((Object)lock3);
        try {
            HdfsUtils.Pair expired = FileLock.locateOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1);
            Assert.assertNull((Object)expired);
            TestFileLock.closeUnderlyingLockFile(lock3);
            Thread.sleep(3000L);
            lock1.heartbeat("1");
            lock2.heartbeat("1");
            FileLock lock3b = FileLock.acquireOldestExpiredLock((FileSystem)fs, (Path)this.locksDir, (int)1, (String)"spout1");
            Assert.assertNotNull((Object)lock3b);
            Assert.assertEquals((String)"Expected lock3 file", (Object)Path.getPathWithoutSchemeAndAuthority((Path)lock3b.getLockFile()), (Object)lock3.getLockFile());
        }
        finally {
            lock1.release();
            lock2.release();
            lock3.release();
            fs.delete(file1, false);
            fs.delete(file2, false);
            try {
                fs.delete(file3, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeUnderlyingLockFile(FileLock lock) throws ReflectiveOperationException {
        Method m = FileLock.class.getDeclaredMethod("forceCloseLockFile", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)lock, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readTextFile(Path file) throws IOException {
        try (FSDataInputStream os = null;){
            os = fs.open(file);
            if (os == null) {
                ArrayList<String> arrayList = null;
                return arrayList;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)os));
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    static {
        conf = new HdfsConfiguration();
    }

    class FileLockingThread
    extends Thread {
        private int thdNum;
        private final FileSystem fs;
        public boolean cleanExit = false;
        private Path fileToLock;
        private Path locksDir;
        private String spoutId;

        public FileLockingThread(int thdNum, FileSystem fs, Path fileToLock, Path locksDir, String spoutId) throws IOException {
            this.thdNum = thdNum;
            this.fs = fs;
            this.fileToLock = fileToLock;
            this.locksDir = locksDir;
            this.spoutId = spoutId;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("FileLockingThread-" + this.thdNum);
            FileLock lock = null;
            try {
                do {
                    System.err.println("Trying lock - " + this.getName());
                    lock = FileLock.tryLock((FileSystem)this.fs, (Path)this.fileToLock, (Path)this.locksDir, (String)this.spoutId);
                    System.err.println("Acquired lock - " + this.getName());
                    if (lock != null) continue;
                    System.out.println("Retrying lock - " + this.getName());
                } while (lock == null);
                this.cleanExit = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                        System.err.println("Released lock - " + this.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            System.err.println("Thread exiting - " + this.getName());
        }
    }
}

