/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.storm.hdfs.spout.DirLock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDirLock {
    static MiniDFSCluster.Builder builder;
    static MiniDFSCluster hdfsCluster;
    static FileSystem fs;
    static String hdfsURI;
    static HdfsConfiguration conf;
    static final int LOCK_EXPIRY_SEC = 1;
    private Path locksDir = new Path("/tmp/lockdir");

    @BeforeClass
    public static void setupClass() throws IOException {
        conf.set("ipc.ping.interval", "5000");
        builder = new MiniDFSCluster.Builder(new Configuration());
        hdfsCluster = builder.build();
        fs = hdfsCluster.getFileSystem();
        hdfsURI = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/";
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        fs.close();
        hdfsCluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        assert (fs.mkdirs(this.locksDir));
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(this.locksDir, true);
    }

    @Test
    public void testBasicLocking() throws Exception {
        DirLock lock = DirLock.tryLock((FileSystem)fs, (Path)this.locksDir);
        Assert.assertTrue((boolean)fs.exists(lock.getLockFile()));
        DirLock lock2 = DirLock.tryLock((FileSystem)fs, (Path)this.locksDir);
        Assert.assertNull((Object)lock2);
        lock.release();
        Assert.assertFalse((boolean)fs.exists(lock.getLockFile()));
        lock2 = DirLock.tryLock((FileSystem)fs, (Path)this.locksDir);
        Assert.assertTrue((boolean)fs.exists(lock2.getLockFile()));
        lock2.release();
        Assert.assertFalse((boolean)fs.exists(lock.getLockFile()));
        lock2.release();
    }

    @Test
    public void testConcurrentLocking() throws Exception {
        DirLockingThread[] thds;
        for (DirLockingThread thd : thds = this.startThreads(100, this.locksDir)) {
            thd.join();
            if (!thd.cleanExit) {
                System.err.println(thd.getName() + " did not exit cleanly");
            }
            Assert.assertTrue((boolean)thd.cleanExit);
        }
        Path lockFile = new Path(this.locksDir + "/" + "DIRLOCK");
        Assert.assertFalse((boolean)fs.exists(lockFile));
    }

    private DirLockingThread[] startThreads(int thdCount, Path dir) throws IOException {
        DirLockingThread[] result = new DirLockingThread[thdCount];
        for (int i = 0; i < thdCount; ++i) {
            result[i] = new DirLockingThread(i, fs, dir);
        }
        for (DirLockingThread thd : result) {
            thd.start();
        }
        return result;
    }

    @Test
    public void testLockRecovery() throws Exception {
        DirLock lock1 = DirLock.tryLock((FileSystem)fs, (Path)this.locksDir);
        Assert.assertNotNull((Object)lock1);
        DirLock lock2 = DirLock.takeOwnershipIfStale((FileSystem)fs, (Path)this.locksDir, (int)1);
        Assert.assertNull((Object)lock2);
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)fs.exists(lock1.getLockFile()));
        DirLock lock3 = DirLock.takeOwnershipIfStale((FileSystem)fs, (Path)this.locksDir, (int)1);
        Assert.assertNotNull((Object)lock3);
        Assert.assertTrue((boolean)fs.exists(lock3.getLockFile()));
        lock3.release();
        Assert.assertFalse((boolean)fs.exists(lock3.getLockFile()));
        lock1.release();
    }

    static {
        conf = new HdfsConfiguration();
    }

    class DirLockingThread
    extends Thread {
        private int thdNum;
        private final FileSystem fs;
        private final Path dir;
        public boolean cleanExit = false;

        public DirLockingThread(int thdNum, FileSystem fs, Path dir) throws IOException {
            this.thdNum = thdNum;
            this.fs = fs;
            this.dir = dir;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("DirLockingThread-" + this.thdNum);
            DirLock lock = null;
            try {
                do {
                    System.err.println("Trying lock " + this.getName());
                    lock = DirLock.tryLock((FileSystem)this.fs, (Path)this.dir);
                    System.err.println("Acquired lock " + this.getName());
                    if (lock != null) continue;
                    System.out.println("Retrying lock - " + this.getName());
                } while (lock == null);
                this.cleanExit = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                        System.err.println("Released lock " + this.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            System.err.println("Thread exiting " + this.getName());
        }
    }
}

