/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.storm.Config;
import org.apache.storm.hdfs.bolt.SequenceFileBolt;
import org.apache.storm.hdfs.bolt.format.DefaultFileNameFormat;
import org.apache.storm.hdfs.bolt.format.DefaultSequenceFormat;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.format.SequenceFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.FileSizeRotationPolicy;
import org.apache.storm.hdfs.bolt.sync.CountSyncPolicy;
import org.apache.storm.hdfs.bolt.sync.SyncPolicy;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSequenceFileBolt {
    private static final Logger LOG = LoggerFactory.getLogger(TestSequenceFileBolt.class);
    private String hdfsURI;
    private DistributedFileSystem fs;
    private MiniDFSCluster hdfsCluster;
    private static final String testRoot = "/unittest";
    Tuple tuple1 = this.generateTestTuple(1L, "first tuple");
    Tuple tuple2 = this.generateTestTuple(2L, "second tuple");
    @Mock
    private OutputCollector collector;
    @Mock
    private TopologyContext topologyContext;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "10");
        conf.setBoolean("dfs.permissions", true);
        File baseDir = new File("./target/hdfs/").getAbsoluteFile();
        FileUtil.fullyDelete((File)baseDir);
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        this.hdfsCluster = builder.build();
        this.fs = this.hdfsCluster.getFileSystem();
        this.hdfsURI = "hdfs://localhost:" + this.hdfsCluster.getNameNodePort() + "/";
    }

    @After
    public void shutDown() throws IOException {
        this.fs.close();
        this.hdfsCluster.shutdown();
    }

    @Test
    public void testTwoTuplesTwoFiles() throws IOException {
        SequenceFileBolt bolt = this.makeSeqBolt(this.hdfsURI, 1, 1.0E-5f);
        bolt.prepare((Map)new Config(), this.topologyContext, this.collector);
        bolt.execute(this.tuple1);
        bolt.execute(this.tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(this.tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(this.tuple2);
        Assert.assertEquals((long)2L, (long)this.countNonZeroLengthFiles(testRoot));
    }

    @Test
    public void testTwoTuplesOneFile() throws IOException {
        SequenceFileBolt bolt = this.makeSeqBolt(this.hdfsURI, 2, 10000.0f);
        bolt.prepare((Map)new Config(), this.topologyContext, this.collector);
        bolt.execute(this.tuple1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.collector});
        bolt.execute(this.tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(this.tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(this.tuple2);
        Assert.assertEquals((long)1L, (long)this.countNonZeroLengthFiles(testRoot));
    }

    @Test
    public void testFailedSync() throws IOException {
        SequenceFileBolt bolt = this.makeSeqBolt(this.hdfsURI, 1, 1.0E-5f);
        bolt.prepare((Map)new Config(), this.topologyContext, this.collector);
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.thrown.expect(RuntimeException.class);
        bolt.execute(this.tuple1);
    }

    private SequenceFileBolt makeSeqBolt(String nameNodeAddr, int countSync, float rotationSizeMB) {
        CountSyncPolicy fieldsSyncPolicy = new CountSyncPolicy(countSync);
        FileSizeRotationPolicy fieldsRotationPolicy = new FileSizeRotationPolicy(rotationSizeMB, FileSizeRotationPolicy.Units.MB);
        DefaultFileNameFormat fieldsFileNameFormat = new DefaultFileNameFormat().withPath(testRoot);
        DefaultSequenceFormat seqFormat = new DefaultSequenceFormat("key", "value");
        return new SequenceFileBolt().withFsUrl(nameNodeAddr).withFileNameFormat((FileNameFormat)fieldsFileNameFormat).withRotationPolicy((FileRotationPolicy)fieldsRotationPolicy).withSequenceFormat((SequenceFormat)seqFormat).withSyncPolicy((SyncPolicy)fieldsSyncPolicy);
    }

    private Tuple generateTestTuple(Long key, String value) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{"key", "value"});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{key, value}), 1, "");
    }

    private int countNonZeroLengthFiles(String path) throws IOException {
        Path p = new Path(path);
        int nonZero = 0;
        for (FileStatus file : this.fs.listStatus(p)) {
            if (file.getLen() <= 0L) continue;
            ++nonZero;
        }
        return nonZero;
    }
}

