/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hdfs.bolt.HdfsBolt;
import org.apache.storm.hdfs.bolt.format.DefaultFileNameFormat;
import org.apache.storm.hdfs.bolt.format.DelimitedRecordFormat;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.format.RecordFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.TimedRotationPolicy;
import org.apache.storm.hdfs.bolt.sync.CountSyncPolicy;
import org.apache.storm.hdfs.bolt.sync.SyncPolicy;
import org.apache.storm.hdfs.common.rotation.MoveFileAction;
import org.apache.storm.hdfs.common.rotation.RotationAction;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.yaml.snakeyaml.Yaml;

public class HdfsFileTopology {
    static final String SENTENCE_SPOUT_ID = "sentence-spout";
    static final String BOLT_ID = "my-bolt";
    static final String TOPOLOGY_NAME = "test-topology";

    public static void main(String[] args) throws Exception {
        Config config = new Config();
        config.setNumWorkers(1);
        SentenceSpout spout = new SentenceSpout();
        CountSyncPolicy syncPolicy = new CountSyncPolicy(1000);
        TimedRotationPolicy rotationPolicy = new TimedRotationPolicy(1.0f, TimedRotationPolicy.TimeUnit.MINUTES);
        DefaultFileNameFormat fileNameFormat = new DefaultFileNameFormat().withPath("/tmp/foo/").withExtension(".txt");
        DelimitedRecordFormat format = new DelimitedRecordFormat().withFieldDelimiter("|");
        Yaml yaml = new Yaml();
        FileInputStream in = new FileInputStream(args[1]);
        Map yamlConf = (Map)yaml.load((InputStream)in);
        ((InputStream)in).close();
        config.put((Object)"hdfs.config", (Object)yamlConf);
        HdfsBolt bolt = new HdfsBolt().withConfigKey("hdfs.config").withFsUrl(args[0]).withFileNameFormat((FileNameFormat)fileNameFormat).withRecordFormat((RecordFormat)format).withRotationPolicy((FileRotationPolicy)rotationPolicy).withSyncPolicy((SyncPolicy)syncPolicy).addRotationAction((RotationAction)new MoveFileAction().toDestination("/tmp/dest2/"));
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(SENTENCE_SPOUT_ID, (IRichSpout)spout, (Number)1);
        builder.setBolt(BOLT_ID, (IRichBolt)bolt, (Number)4).shuffleGrouping(SENTENCE_SPOUT_ID);
        if (args.length == 2) {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology(TOPOLOGY_NAME, (Map)config, builder.createTopology());
            HdfsFileTopology.waitForSeconds(120);
            cluster.killTopology(TOPOLOGY_NAME);
            cluster.shutdown();
            System.exit(0);
        } else if (args.length == 3) {
            StormSubmitter.submitTopology((String)args[2], (Map)config, (StormTopology)builder.createTopology());
        } else {
            System.out.println("Usage: HdfsFileTopology [hdfs url] [hdfs yaml config file] <topology name>");
        }
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class MyBolt
    extends BaseRichBolt {
        private HashMap<String, Long> counts = null;
        private OutputCollector collector;

        public void prepare(Map config, TopologyContext context, OutputCollector collector) {
            this.counts = new HashMap();
            this.collector = collector;
        }

        public void execute(Tuple tuple) {
            this.collector.ack(tuple);
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
        }

        public void cleanup() {
        }
    }

    public static class SentenceSpout
    extends BaseRichSpout {
        private ConcurrentHashMap<UUID, Values> pending;
        private SpoutOutputCollector collector;
        private String[] sentences = new String[]{"my dog has fleas", "i like cold beverages", "the dog ate my homework", "don't have a cow man", "i don't think i like fleas"};
        private int index = 0;
        private int count = 0;
        private long total = 0L;

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"sentence", "timestamp"}));
        }

        public void open(Map config, TopologyContext context, SpoutOutputCollector collector) {
            this.collector = collector;
            this.pending = new ConcurrentHashMap();
        }

        public void nextTuple() {
            Values values = new Values(new Object[]{this.sentences[this.index], System.currentTimeMillis()});
            UUID msgId = UUID.randomUUID();
            this.pending.put(msgId, values);
            this.collector.emit((List)values, (Object)msgId);
            ++this.index;
            if (this.index >= this.sentences.length) {
                this.index = 0;
            }
            ++this.count;
            ++this.total;
            if (this.count > 20000) {
                this.count = 0;
                System.out.println("Pending count: " + this.pending.size() + ", total: " + this.total);
            }
            Thread.yield();
        }

        public void ack(Object msgId) {
            this.pending.remove(msgId);
        }

        public void fail(Object msgId) {
            System.out.println("**** RESENDING FAILED TUPLE");
            this.collector.emit((List)this.pending.get(msgId), msgId);
        }
    }
}

