/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.storm.Config;
import org.apache.storm.hdfs.bolt.AvroGenericRecordBolt;
import org.apache.storm.hdfs.bolt.format.DefaultFileNameFormat;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.FileSizeRotationPolicy;
import org.apache.storm.hdfs.bolt.sync.CountSyncPolicy;
import org.apache.storm.hdfs.bolt.sync.SyncPolicy;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class AvroGenericRecordBoltTest {
    private String hdfsURI;
    private DistributedFileSystem fs;
    private MiniDFSCluster hdfsCluster;
    private static final String testRoot = "/unittest";
    private static final Schema schema;
    private static final Tuple tuple1;
    private static final Tuple tuple2;
    private static final String userSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"foo1\",\"type\":\"string\"},{ \"name\":\"int1\", \"type\":\"int\" }]}";
    @Mock
    private OutputCollector collector;
    @Mock
    private TopologyContext topologyContext;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "10");
        conf.setBoolean("dfs.permissions", true);
        File baseDir = new File("./target/hdfs/").getAbsoluteFile();
        FileUtil.fullyDelete((File)baseDir);
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        this.hdfsCluster = builder.build();
        this.fs = this.hdfsCluster.getFileSystem();
        this.hdfsURI = this.fs.getUri() + "/";
    }

    @After
    public void shutDown() throws IOException {
        this.fs.close();
        this.hdfsCluster.shutdown();
    }

    @Test
    public void multipleTuplesOneFile() throws IOException {
        AvroGenericRecordBolt bolt = this.makeAvroBolt(this.hdfsURI, 1, 1.0f, userSchema);
        bolt.prepare((Map)new Config(), this.topologyContext, this.collector);
        bolt.execute(tuple1);
        bolt.execute(tuple2);
        bolt.execute(tuple1);
        bolt.execute(tuple2);
        Assert.assertEquals((long)1L, (long)this.countNonZeroLengthFiles(testRoot));
        this.verifyAllAvroFiles(testRoot, schema);
    }

    @Test
    public void multipleTuplesMutliplesFiles() throws IOException {
        AvroGenericRecordBolt bolt = this.makeAvroBolt(this.hdfsURI, 1, 1.0E-4f, userSchema);
        bolt.prepare((Map)new Config(), this.topologyContext, this.collector);
        bolt.execute(tuple1);
        bolt.execute(tuple2);
        bolt.execute(tuple1);
        bolt.execute(tuple2);
        Assert.assertEquals((long)4L, (long)this.countNonZeroLengthFiles(testRoot));
        this.verifyAllAvroFiles(testRoot, schema);
    }

    private AvroGenericRecordBolt makeAvroBolt(String nameNodeAddr, int countSync, float rotationSizeMB, String schemaAsString) {
        CountSyncPolicy fieldsSyncPolicy = new CountSyncPolicy(countSync);
        DefaultFileNameFormat fieldsFileNameFormat = new DefaultFileNameFormat().withPath(testRoot);
        FileSizeRotationPolicy rotationPolicy = new FileSizeRotationPolicy(rotationSizeMB, FileSizeRotationPolicy.Units.MB);
        return new AvroGenericRecordBolt().withFsUrl(nameNodeAddr).withFileNameFormat((FileNameFormat)fieldsFileNameFormat).withSchemaAsString(schemaAsString).withRotationPolicy((FileRotationPolicy)rotationPolicy).withSyncPolicy((SyncPolicy)fieldsSyncPolicy);
    }

    private static Tuple generateTestTuple(GenericRecord record) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{"record"});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{record}), 1, "");
    }

    private void verifyAllAvroFiles(String path, Schema schema) throws IOException {
        Path p = new Path(path);
        for (FileStatus file : this.fs.listStatus(p)) {
            if (file.getLen() <= 0L) continue;
            this.fileIsGoodAvro(file.getPath(), schema);
        }
    }

    private int countNonZeroLengthFiles(String path) throws IOException {
        Path p = new Path(path);
        int nonZero = 0;
        for (FileStatus file : this.fs.listStatus(p)) {
            if (file.getLen() <= 0L) continue;
            ++nonZero;
        }
        return nonZero;
    }

    private void fileIsGoodAvro(Path path, Schema schema) throws IOException {
        int bytesRead;
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        FSDataInputStream in = this.fs.open(path, 0);
        FileOutputStream out = new FileOutputStream("target/FOO.avro");
        byte[] buffer = new byte[100];
        while ((bytesRead = in.read(buffer)) > 0) {
            out.write(buffer, 0, bytesRead);
        }
        out.close();
        File file = new File("target/FOO.avro");
        DataFileReader dataFileReader = new DataFileReader(file, (DatumReader)datumReader);
        GenericRecord user = null;
        while (dataFileReader.hasNext()) {
            user = (GenericRecord)dataFileReader.next(user);
            System.out.println(user);
        }
        file.delete();
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        schema = parser.parse(userSchema);
        GenericData.Record record1 = new GenericData.Record(schema);
        record1.put("foo1", (Object)"bar1");
        record1.put("int1", (Object)1);
        tuple1 = AvroGenericRecordBoltTest.generateTestTuple((GenericRecord)record1);
        GenericData.Record record2 = new GenericData.Record(schema);
        record2.put("foo1", (Object)"bar2");
        record2.put("int1", (Object)2);
        tuple2 = AvroGenericRecordBoltTest.generateTestTuple((GenericRecord)record2);
    }
}

