/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.hdfs.blobstore.HdfsBlobStoreFile;
import org.apache.storm.hdfs.blobstore.HdfsBlobStoreImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBlobStoreImplTest {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsBlobStoreImplTest.class);
    protected static Configuration hadoopConf;
    protected static MiniDFSCluster dfscluster;
    private static String KEYDIR;
    private Path blobDir = new Path("/storm/blobstore1");
    private Path fullKeyDir = new Path(this.blobDir, KEYDIR);
    private String BLOBSTORE_DATA = "data";

    @BeforeClass
    public static void init() {
        System.setProperty("test.build.data", "target/test/data");
        if (hadoopConf == null) {
            hadoopConf = new Configuration();
        }
        try {
            if (dfscluster == null) {
                dfscluster = new MiniDFSCluster.Builder(hadoopConf).build();
                dfscluster.waitActive();
            }
        }
        catch (IOException e) {
            LOG.error("error creating MiniDFSCluster");
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        if (dfscluster != null) {
            dfscluster.shutdown();
        }
    }

    @Test
    public void testMultiple() throws Exception {
        String testString = "testingblob";
        String validKey = "validkeyBasic";
        DistributedFileSystem fs = dfscluster.getFileSystem();
        HashMap<String, Object> conf = new HashMap<String, Object>();
        TestHdfsBlobStoreImpl hbs = new TestHdfsBlobStoreImpl(this.blobDir, conf, hadoopConf);
        Assert.assertTrue((String)"BlobStore dir wasn't created", (boolean)fs.exists(this.blobDir));
        Assert.assertEquals((String)"BlobStore dir was created with wrong permissions", (Object)HdfsBlobStoreImpl.BLOBSTORE_DIR_PERMISSION, (Object)fs.getFileStatus(this.blobDir).getPermission());
        Assert.assertFalse((String)"file exists but shouldn't", (boolean)hbs.exists("bogus"));
        BlobStoreFile pfile = hbs.write(validKey, false);
        SettableBlobMeta meta = new SettableBlobMeta();
        meta.set_replication_factor(1);
        pfile.setMetadata(meta);
        OutputStream ios = pfile.getOutputStream();
        ios.write(testString.getBytes(Charset.forName("UTF-8")));
        ios.close();
        Assert.assertTrue((String)"BlobStore key dir wasn't created", (boolean)fs.exists(this.fullKeyDir));
        pfile.commit();
        Path dataFile = new Path(new Path(this.fullKeyDir, validKey), this.BLOBSTORE_DATA);
        Assert.assertTrue((String)"blob data not committed", (boolean)fs.exists(dataFile));
        Assert.assertEquals((String)"BlobStore dir was created with wrong permissions", (Object)HdfsBlobStoreFile.BLOBSTORE_FILE_PERMISSION, (Object)fs.getFileStatus(dataFile).getPermission());
        Assert.assertTrue((String)"key doesn't exist but should", (boolean)hbs.exists(validKey));
        BlobStoreFile readpFile = hbs.read(validKey);
        String readString = IOUtils.toString((InputStream)readpFile.getInputStream(), (String)"UTF-8");
        Assert.assertEquals((String)"string read from blob doesn't match", (Object)testString, (Object)readString);
        Iterator keys = hbs.listKeys();
        Assert.assertTrue((String)"blob has one key", (boolean)keys.hasNext());
        Assert.assertEquals((String)"one key in blobstore", (Object)validKey, keys.next());
        hbs.deleteKey(validKey);
        Assert.assertFalse((String)"key not deleted", (boolean)fs.exists(dataFile));
        Assert.assertFalse((String)"key not deleted", (boolean)hbs.exists(validKey));
        String testString2 = "testingblob2";
        String validKey2 = "validkey2";
        pfile = hbs.write(validKey, false);
        pfile.setMetadata(meta);
        ios = pfile.getOutputStream();
        ios.write(testString.getBytes(Charset.forName("UTF-8")));
        ios.close();
        Assert.assertTrue((String)"BlobStore key dir wasn't created", (boolean)fs.exists(this.fullKeyDir));
        pfile.commit();
        Assert.assertTrue((String)"blob data not committed", (boolean)fs.exists(dataFile));
        Assert.assertEquals((String)"BlobStore dir was created with wrong permissions", (Object)HdfsBlobStoreFile.BLOBSTORE_FILE_PERMISSION, (Object)fs.getFileStatus(dataFile).getPermission());
        Assert.assertTrue((String)"key doesn't exist but should", (boolean)hbs.exists(validKey));
        pfile = hbs.write(validKey2, false);
        pfile.setMetadata(meta);
        OutputStream ios2 = pfile.getOutputStream();
        ios2.write(testString2.getBytes(Charset.forName("UTF-8")));
        ios2.close();
        pfile.commit();
        Path dataFile2 = new Path(new Path(this.fullKeyDir, validKey2), this.BLOBSTORE_DATA);
        Assert.assertTrue((String)"blob data not committed", (boolean)fs.exists(dataFile2));
        Assert.assertEquals((String)"BlobStore dir was created with wrong permissions", (Object)HdfsBlobStoreFile.BLOBSTORE_FILE_PERMISSION, (Object)fs.getFileStatus(dataFile2).getPermission());
        Assert.assertTrue((String)"key doesn't exist but should", (boolean)hbs.exists(validKey2));
        keys = hbs.listKeys();
        int total = 0;
        boolean key1Found = false;
        boolean key2Found = false;
        while (keys.hasNext()) {
            ++total;
            String key = (String)keys.next();
            if (key.equals(validKey)) {
                key1Found = true;
                continue;
            }
            if (key.equals(validKey2)) {
                key2Found = true;
                continue;
            }
            Assert.fail((String)("Found key that wasn't expected: " + key));
        }
        Assert.assertEquals((String)"number of keys is wrong", (long)2L, (long)total);
        Assert.assertTrue((String)"blobstore missing key1", (boolean)key1Found);
        Assert.assertTrue((String)"blobstore missing key2", (boolean)key2Found);
        readpFile = hbs.read(validKey);
        readString = IOUtils.toString((InputStream)readpFile.getInputStream(), (String)"UTF-8");
        Assert.assertEquals((String)"string read from blob doesn't match", (Object)testString, (Object)readString);
        readpFile = hbs.read(validKey2);
        readString = IOUtils.toString((InputStream)readpFile.getInputStream(), (String)"UTF-8");
        Assert.assertEquals((String)"string read from blob doesn't match", (Object)testString2, (Object)readString);
        hbs.deleteKey(validKey);
        Assert.assertFalse((String)"key not deleted", (boolean)hbs.exists(validKey));
        hbs.deleteKey(validKey2);
        Assert.assertFalse((String)"key not deleted", (boolean)hbs.exists(validKey2));
    }

    @Test
    public void testGetFileLength() throws IOException {
        DistributedFileSystem fs = dfscluster.getFileSystem();
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String validKey = "validkeyBasic";
        String testString = "testingblob";
        TestHdfsBlobStoreImpl hbs = new TestHdfsBlobStoreImpl(this.blobDir, conf, hadoopConf);
        BlobStoreFile pfile = hbs.write(validKey, false);
        SettableBlobMeta meta = new SettableBlobMeta();
        meta.set_replication_factor(1);
        pfile.setMetadata(meta);
        OutputStream ios = pfile.getOutputStream();
        ios.write(testString.getBytes(Charset.forName("UTF-8")));
        ios.close();
        Assert.assertEquals((long)testString.getBytes(Charset.forName("UTF-8")).length, (long)pfile.getFileLength());
    }

    static {
        KEYDIR = "0";
    }

    public class TestHdfsBlobStoreImpl
    extends HdfsBlobStoreImpl {
        public TestHdfsBlobStoreImpl(Path path, Map<String, Object> conf) throws IOException {
            super(path, conf);
        }

        public TestHdfsBlobStoreImpl(Path path, Map<String, Object> conf, Configuration hconf) throws IOException {
            super(path, conf, hconf);
        }

        protected Path getKeyDir(String key) {
            return new Path(new Path(HdfsBlobStoreImplTest.this.blobDir, KEYDIR), key);
        }
    }
}

