/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.Subject;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.hdfs.blobstore.HdfsBlobStore;
import org.apache.storm.security.auth.NimbusPrincipal;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreTest {
    private static final Logger LOG = LoggerFactory.getLogger(BlobStoreTest.class);
    protected static MiniDFSCluster dfscluster = null;
    protected static Configuration hadoopConf = null;
    URI base;
    File baseFile;
    private static Map conf = new HashMap();
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int ADMIN = 4;

    @Before
    public void init() {
        System.setProperty("test.build.data", "target/test/data");
        BlobStoreTest.initializeConfigs();
        this.baseFile = new File("/tmp/blob-store-test-" + UUID.randomUUID());
        this.base = this.baseFile.toURI();
    }

    @After
    public void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)this.baseFile);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException {
        if (dfscluster != null) {
            dfscluster.shutdown();
        }
    }

    public static void initializeConfigs() {
        conf.put("nimbus.admins", "admin");
        conf.put("nimbus.supervisor.users", "supervisor");
    }

    public static Subject getNimbusSubject() {
        Subject nimbus = new Subject();
        nimbus.getPrincipals().add((Principal)new NimbusPrincipal());
        return nimbus;
    }

    public static void assertStoreHasExactly(BlobStore store, Subject who, String ... keys) throws IOException, KeyNotFoundException, AuthorizationException {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(keys));
        HashSet<String> found = new HashSet<String>();
        Iterator c = store.listKeys();
        while (c.hasNext()) {
            String keyName = (String)c.next();
            found.add(keyName);
        }
        HashSet extra = new HashSet(found);
        extra.removeAll(expected);
        Assert.assertTrue((String)("Found extra keys in the blob store " + extra), (boolean)extra.isEmpty());
        HashSet<String> missing = new HashSet<String>(expected);
        missing.removeAll(found);
        Assert.assertTrue((String)("Found keys missing from the blob store " + missing), (boolean)missing.isEmpty());
    }

    public static void assertStoreHasExactly(BlobStore store, String ... keys) throws IOException, KeyNotFoundException, AuthorizationException {
        BlobStoreTest.assertStoreHasExactly(store, null, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readInt(BlobStore store, Subject who, String key) throws IOException, KeyNotFoundException, AuthorizationException {
        try (InputStreamWithMeta in = store.getBlob(key, who);){
            int n = in.read();
            return n;
        }
    }

    public static int readInt(BlobStore store, String key) throws IOException, KeyNotFoundException, AuthorizationException {
        return BlobStoreTest.readInt(store, null, key);
    }

    public static void readAssertEquals(BlobStore store, String key, int value) throws IOException, KeyNotFoundException, AuthorizationException {
        Assert.assertEquals((long)value, (long)BlobStoreTest.readInt(store, key));
    }

    public void readAssertEqualsWithAuth(BlobStore store, Subject who, String key, int value) throws IOException, KeyNotFoundException, AuthorizationException {
        Assert.assertEquals((long)value, (long)BlobStoreTest.readInt(store, who, key));
    }

    private HdfsBlobStore initHdfs(String dirName) throws Exception {
        if (hadoopConf == null) {
            hadoopConf = new Configuration();
        }
        try {
            if (dfscluster == null) {
                dfscluster = new MiniDFSCluster.Builder(hadoopConf).numDataNodes(3).build();
                dfscluster.waitActive();
            }
        }
        catch (IOException e) {
            LOG.error("error creating MiniDFSCluster");
        }
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("blobstore.dir", dirName);
        conf.put("storm.principal.tolocal", "org.apache.storm.security.auth.DefaultPrincipalToLocal");
        conf.put("storm.blobstore.replication.factor", 3);
        HdfsBlobStore store = new HdfsBlobStore();
        store.prepareInternal(conf, null, dfscluster.getConfiguration(0));
        return store;
    }

    @Test
    public void testHdfsReplication() throws Exception {
        HdfsBlobStore store = this.initHdfs("/storm/blobstoreReplication");
        this.testReplication("/storm/blobstoreReplication/test", (BlobStore)store);
    }

    @Test
    public void testBasicHdfs() throws Exception {
        this.testBasic((BlobStore)this.initHdfs("/storm/blobstore1"));
    }

    @Test
    public void testMultipleHdfs() throws Exception {
        this.testMultiple((BlobStore)this.initHdfs("/storm/blobstore2"));
    }

    @Test
    public void testHdfsWithAuth() throws Exception {
        this.testWithAuthentication((BlobStore)this.initHdfs("/storm/blobstore3"));
    }

    public void testReplication(String path, BlobStore store) throws Exception {
        SettableBlobMeta metadata = new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING);
        metadata.set_replication_factor(4);
        AtomicOutputStream out = store.createBlob("test", metadata, null);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", null), (long)4L);
        store.deleteBlob("test", null);
        Subject admin = this.getSubject("admin");
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        metadata.set_replication_factor(4);
        out = store.createBlob("test", metadata, admin);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", admin), (long)4L);
        store.updateBlobReplication("test", 5, admin);
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", admin), (long)5L);
        store.deleteBlob("test", admin);
        Subject supervisor = this.getSubject("supervisor");
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        metadata.set_replication_factor(4);
        out = store.createBlob("test", metadata, supervisor);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", supervisor), (long)4L);
        store.updateBlobReplication("test", 5, supervisor);
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", supervisor), (long)5L);
        store.deleteBlob("test", supervisor);
        String createSubject = "createSubject";
        String writeSubject = "writeSubject";
        String adminSubject = "adminSubject";
        Subject who = this.getSubject(createSubject);
        AccessControl writeAccess = new AccessControl(AccessControlType.USER, 1);
        AccessControl adminAccess = new AccessControl(AccessControlType.USER, 4);
        writeAccess.set_name(writeSubject);
        adminAccess.set_name(adminSubject);
        List<AccessControl> acl = Arrays.asList(writeAccess, adminAccess);
        metadata = new SettableBlobMeta(acl);
        metadata.set_replication_factor(4);
        out = store.createBlob("test", metadata, who);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        who = this.getSubject(writeSubject);
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", who), (long)4L);
        who = this.getSubject(adminSubject);
        store.updateBlobReplication("test", 5, who);
        Assert.assertEquals((String)"Blobstore replication not matching", (long)store.getBlobReplication("test", who), (long)5L);
        store.deleteBlob("test", this.getSubject(createSubject));
    }

    public Subject getSubject(String name) {
        Subject subject = new Subject();
        SingleUserPrincipal user = new SingleUserPrincipal(name);
        subject.getPrincipals().add((Principal)user);
        return subject;
    }

    public void testWithAuthentication(BlobStore store) throws Exception {
        Subject admin = this.getSubject("admin");
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        SettableBlobMeta metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        AtomicOutputStream out = store.createBlob("test", metadata, admin);
        BlobStoreTest.assertStoreHasExactly(store, "test");
        out.write(1);
        out.close();
        store.deleteBlob("test", admin);
        Subject supervisor = this.getSubject("supervisor");
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        out = store.createBlob("test", metadata, supervisor);
        BlobStoreTest.assertStoreHasExactly(store, "test");
        out.write(1);
        out.close();
        store.deleteBlob("test", supervisor);
        Subject nimbus = BlobStoreTest.getNimbusSubject();
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        out = store.createBlob("test", metadata, nimbus);
        BlobStoreTest.assertStoreHasExactly(store, "test");
        out.write(1);
        out.close();
        store.deleteBlob("test", nimbus);
        Subject who = this.getSubject("test_subject");
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        metadata = new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING);
        out = store.createBlob("test", metadata, who);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertTrue((String)"ACL does not contain WORLD_EVERYTHING", (boolean)metadata.toString().contains("AccessControl(type:OTHER, access:7)"));
        this.readAssertEqualsWithAuth(store, who, "test", 1);
        LOG.info("Deleting test");
        store.deleteBlob("test", who);
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        LOG.info("Creating test again");
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        out = store.createBlob("test", metadata, who);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertTrue((String)"ACL does not contain WORLD_EVERYTHING", (!metadata.toString().contains("AccessControl(type:OTHER, access:7)") ? 1 : 0) != 0);
        this.readAssertEqualsWithAuth(store, who, "test", 2);
        LOG.info("Updating test");
        out = store.updateBlob("test", who);
        out.write(3);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        this.readAssertEqualsWithAuth(store, who, "test", 3);
        LOG.info("Updating test again");
        out = store.updateBlob("test", who);
        out.write(4);
        out.flush();
        LOG.info("SLEEPING");
        Thread.sleep(2L);
        BlobStoreTest.assertStoreHasExactly(store, "test");
        this.readAssertEqualsWithAuth(store, who, "test", 3);
        who = new Subject();
        metadata = new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING);
        LOG.info("Creating test");
        out = store.createBlob("test-empty-subject-WE", metadata, who);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test-empty-subject-WE", "test");
        Assert.assertTrue((String)"ACL does not contain WORLD_EVERYTHING", (boolean)metadata.toString().contains("AccessControl(type:OTHER, access:7)"));
        this.readAssertEqualsWithAuth(store, who, "test-empty-subject-WE", 2);
        who = new Subject();
        metadata = new SettableBlobMeta(BlobStoreAclHandler.DEFAULT);
        LOG.info("Creating other");
        out = store.createBlob("test-empty-subject-DEF", metadata, who);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test-empty-subject-DEF", "test", "test-empty-subject-WE");
        Assert.assertTrue((String)"ACL does not contain WORLD_EVERYTHING", (boolean)metadata.toString().contains("AccessControl(type:OTHER, access:7)"));
        this.readAssertEqualsWithAuth(store, who, "test-empty-subject-DEF", 2);
        if (store instanceof HdfsBlobStore) {
            ((HdfsBlobStore)store).fullCleanup(1L);
        } else {
            Assert.fail((String)"Error the blobstore is of unknowntype");
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testBasic(BlobStore store) throws Exception {
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        LOG.info("Creating test");
        SettableBlobMeta metadata = new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING);
        AtomicOutputStream out = store.createBlob("test", metadata, null);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        Assert.assertTrue((String)"ACL does not contain WORLD_EVERYTHING", (boolean)metadata.toString().contains("AccessControl(type:OTHER, access:7)"));
        BlobStoreTest.readAssertEquals(store, "test", 1);
        LOG.info("Deleting test");
        store.deleteBlob("test", null);
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        metadata = new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING);
        LOG.info("Creating test again");
        out = store.createBlob("test", metadata, null);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        BlobStoreTest.readAssertEquals(store, "test", 2);
        LOG.info("Updating test");
        out = store.updateBlob("test", null);
        out.write(3);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        BlobStoreTest.readAssertEquals(store, "test", 3);
        LOG.info("Updating test again");
        out = store.updateBlob("test", null);
        out.write(4);
        out.flush();
        LOG.info("SLEEPING");
        Thread.sleep(2L);
        if (store instanceof HdfsBlobStore) {
            ((HdfsBlobStore)store).fullCleanup(1L);
        } else {
            Assert.fail((String)"Error the blobstore is of unknowntype");
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMultiple(BlobStore store) throws Exception {
        BlobStoreTest.assertStoreHasExactly(store, new String[0]);
        LOG.info("Creating test");
        AtomicOutputStream out = store.createBlob("test", new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING), null);
        out.write(1);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test");
        BlobStoreTest.readAssertEquals(store, "test", 1);
        LOG.info("Creating other");
        out = store.createBlob("other", new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING), null);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test", "other");
        BlobStoreTest.readAssertEquals(store, "test", 1);
        BlobStoreTest.readAssertEquals(store, "other", 2);
        LOG.info("Updating other");
        out = store.updateBlob("other", null);
        out.write(5);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test", "other");
        BlobStoreTest.readAssertEquals(store, "test", 1);
        BlobStoreTest.readAssertEquals(store, "other", 5);
        LOG.info("Deleting test");
        store.deleteBlob("test", null);
        BlobStoreTest.assertStoreHasExactly(store, "other");
        BlobStoreTest.readAssertEquals(store, "other", 5);
        LOG.info("Creating test again");
        out = store.createBlob("test", new SettableBlobMeta(BlobStoreAclHandler.WORLD_EVERYTHING), null);
        out.write(2);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test", "other");
        BlobStoreTest.readAssertEquals(store, "test", 2);
        BlobStoreTest.readAssertEquals(store, "other", 5);
        LOG.info("Updating test");
        out = store.updateBlob("test", null);
        out.write(3);
        out.close();
        BlobStoreTest.assertStoreHasExactly(store, "test", "other");
        BlobStoreTest.readAssertEquals(store, "test", 3);
        BlobStoreTest.readAssertEquals(store, "other", 5);
        LOG.info("Deleting other");
        store.deleteBlob("other", null);
        BlobStoreTest.assertStoreHasExactly(store, "test");
        BlobStoreTest.readAssertEquals(store, "test", 3);
        LOG.info("Updating test again");
        out = store.updateBlob("test", null);
        out.write(4);
        out.flush();
        LOG.info("SLEEPING");
        Thread.sleep(2L);
        if (store instanceof HdfsBlobStore) {
            ((HdfsBlobStore)store).fullCleanup(1L);
        } else {
            Assert.fail((String)"Error the blobstore is of unknowntype");
        }
        BlobStoreTest.assertStoreHasExactly(store, "test");
        BlobStoreTest.readAssertEquals(store, "test", 3);
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

