/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.avro;

import org.apache.avro.Schema;
import org.apache.storm.hdfs.avro.AvroSchemaRegistry;
import org.apache.storm.hdfs.avro.GenericAvroSerializer;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericAvroSerializer {
    private static final String schemaString1 = "{\"type\":\"record\",\"name\":\"stormtest1\",\"fields\":[{\"name\":\"foo1\",\"type\":\"string\"},{ \"name\":\"int1\", \"type\":\"int\" }]}";
    private static final String schemaString2 = "{\"type\":\"record\",\"name\":\"stormtest2\",\"fields\":[{\"name\":\"foobar1\",\"type\":\"string\"},{ \"name\":\"intint1\", \"type\":\"int\" }]}";
    private static final Schema schema1;
    private static final Schema schema2;
    AvroSchemaRegistry reg = new GenericAvroSerializer();

    @Test
    public void testSchemas() {
        this.testTheSchema(schema1);
        this.testTheSchema(schema2);
    }

    @Test
    public void testDifferentFPs() {
        String fp1 = this.reg.getFingerprint(schema1);
        String fp2 = this.reg.getFingerprint(schema2);
        Assert.assertNotEquals((Object)fp1, (Object)fp2);
    }

    private void testTheSchema(Schema schema) {
        String fp1 = this.reg.getFingerprint(schema);
        Schema found = this.reg.getSchema(fp1);
        String fp2 = this.reg.getFingerprint(found);
        Assert.assertEquals((Object)found, (Object)schema);
        Assert.assertEquals((Object)fp1, (Object)fp2);
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        schema1 = parser.parse(schemaString1);
        parser = new Schema.Parser();
        schema2 = parser.parse(schemaString2);
    }
}

