/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jms.trident;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.jms.JmsProvider;
import org.apache.storm.jms.JmsTupleProducer;
import org.apache.storm.jms.trident.JmsBatch;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentJmsSpout
implements ITridentSpout<JmsBatch> {
    public static final String MAX_BATCH_SIZE_CONF = "topology.spout.max.batch.size";
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final long serialVersionUID = -3469351154693356655L;
    private JmsTupleProducer tupleProducer;
    private JmsProvider jmsProvider;
    private int jmsAcknowledgeMode = 1;
    private String name = "JmsSpout_" + nameIndex++;
    private static int nameIndex = 1;

    public TridentJmsSpout named(String name) {
        this.name = name;
        return this;
    }

    public TridentJmsSpout withJmsProvider(JmsProvider provider) {
        this.jmsProvider = provider;
        return this;
    }

    public TridentJmsSpout withTupleProducer(JmsTupleProducer tupleProducer) {
        this.tupleProducer = tupleProducer;
        return this;
    }

    public TridentJmsSpout withJmsAcknowledgeMode(int jmsAcknowledgeMode) {
        TridentJmsSpout.toDeliveryModeString(jmsAcknowledgeMode);
        this.jmsAcknowledgeMode = jmsAcknowledgeMode;
        return this;
    }

    private static final String toDeliveryModeString(int acknowledgeMode) {
        switch (acknowledgeMode) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        throw new IllegalArgumentException("Unknown JMS Acknowledge mode " + acknowledgeMode + " (See javax.jms.Session for valid values)");
    }

    public ITridentSpout.BatchCoordinator<JmsBatch> getCoordinator(String txStateId, Map conf, TopologyContext context) {
        return new JmsBatchCoordinator(this.name);
    }

    public ITridentSpout.Emitter<JmsBatch> getEmitter(String txStateId, Map conf, TopologyContext context) {
        return new JmsEmitter(this.name, this.jmsProvider, this.tupleProducer, this.jmsAcknowledgeMode, conf);
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        OutputFieldsGetter fieldGetter = new OutputFieldsGetter();
        this.tupleProducer.declareOutputFields((OutputFieldsDeclarer)fieldGetter);
        StreamInfo streamInfo = (StreamInfo)fieldGetter.getFieldsDeclaration().get("default");
        if (streamInfo == null) {
            throw new IllegalArgumentException("Jms Tuple producer has not declared output fields for the default stream");
        }
        return new Fields(streamInfo.get_output_fields());
    }

    private class JmsBatchCoordinator
    implements ITridentSpout.BatchCoordinator<JmsBatch> {
        private final String name;
        private final Logger LOG = LoggerFactory.getLogger(JmsBatchCoordinator.class);

        public JmsBatchCoordinator(String name) {
            this.name = name;
            this.LOG.info("Created batch coordinator for " + name);
        }

        public JmsBatch initializeTransaction(long txid, JmsBatch prevMetadata, JmsBatch curMetadata) {
            this.LOG.debug("Initialise transaction " + txid + " for " + this.name);
            return null;
        }

        public void success(long txid) {
        }

        public boolean isReady(long txid) {
            return true;
        }

        public void close() {
        }
    }

    private class JmsEmitter
    implements ITridentSpout.Emitter<JmsBatch>,
    MessageListener {
        private final LinkedBlockingQueue<Message> queue;
        private final Connection connection;
        private final Session session;
        private final RotatingMap<Long, List<Message>> batchMessageMap;
        private final long rotateTimeMillis;
        private final int maxBatchSize;
        private final String name;
        private long lastRotate;
        private final Logger LOG = LoggerFactory.getLogger(JmsEmitter.class);

        public JmsEmitter(String name, JmsProvider jmsProvider, JmsTupleProducer tupleProducer, int jmsAcknowledgeMode, Map conf) {
            if (jmsProvider == null) {
                throw new IllegalStateException("JMS provider has not been set.");
            }
            if (tupleProducer == null) {
                throw new IllegalStateException("JMS Tuple Producer has not been set.");
            }
            this.queue = new LinkedBlockingQueue();
            this.name = name;
            this.batchMessageMap = new RotatingMap(3);
            this.rotateTimeMillis = 1000L * (long)((Number)conf.get("topology.message.timeout.secs")).intValue();
            this.lastRotate = System.currentTimeMillis();
            Number batchSize = (Number)conf.get(TridentJmsSpout.MAX_BATCH_SIZE_CONF);
            this.maxBatchSize = batchSize != null ? batchSize.intValue() : 1000;
            try {
                ConnectionFactory cf = jmsProvider.connectionFactory();
                Destination dest = jmsProvider.destination();
                this.connection = cf.createConnection();
                this.session = this.connection.createSession(false, jmsAcknowledgeMode);
                MessageConsumer consumer = this.session.createConsumer(dest);
                consumer.setMessageListener((MessageListener)this);
                this.connection.start();
                this.LOG.info("Created JmsEmitter with max batch size " + this.maxBatchSize + " rotate time " + this.rotateTimeMillis + "ms and destination " + dest + " for " + name);
            }
            catch (Exception e) {
                this.LOG.warn("Error creating JMS connection.", (Throwable)e);
                throw new IllegalStateException("Could not create JMS connection for spout ", e);
            }
        }

        public void success(TransactionAttempt tx) {
            List messages = (List)this.batchMessageMap.remove((Object)tx.getTransactionId());
            if (messages != null) {
                if (!messages.isEmpty()) {
                    this.LOG.debug("Success for batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
                }
                for (Message msg : messages) {
                    String messageId = "UnknownId";
                    try {
                        messageId = msg.getJMSMessageID();
                        msg.acknowledge();
                        this.LOG.trace("Acknowledged message " + messageId);
                    }
                    catch (JMSException e) {
                        this.LOG.warn("Failed to acknowledge message " + messageId, (Throwable)e);
                    }
                }
            } else {
                this.LOG.warn("No messages found in batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId());
            }
        }

        private void fail(Long transactionId, List<Message> messages) {
            this.LOG.debug("Failure for batch with transaction id " + transactionId + " for " + this.name);
            if (messages != null) {
                for (Message msg : messages) {
                    try {
                        this.LOG.trace("Failed message " + msg.getJMSMessageID());
                    }
                    catch (JMSException e) {
                        this.LOG.warn("Could not identify failed message ", (Throwable)e);
                    }
                }
            } else {
                this.LOG.warn("Failed batch has no messages with transaction id " + transactionId);
            }
        }

        public void close() {
            try {
                this.LOG.info("Closing JMS connection.");
                this.session.close();
                this.connection.close();
            }
            catch (JMSException e) {
                this.LOG.warn("Error closing JMS connection.", (Throwable)e);
            }
        }

        public void emitBatch(TransactionAttempt tx, JmsBatch coordinatorMeta, TridentCollector collector) {
            long now = System.currentTimeMillis();
            if (now - this.lastRotate > this.rotateTimeMillis) {
                Map failed = this.batchMessageMap.rotate();
                for (Long id : failed.keySet()) {
                    this.LOG.warn("TIMED OUT batch with transaction id " + id + " for " + this.name);
                    this.fail(id, (List)failed.get(id));
                }
                this.lastRotate = now;
            }
            if (this.batchMessageMap.containsKey((Object)tx.getTransactionId())) {
                this.LOG.warn("FAILED duplicate batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
                this.fail(tx.getTransactionId(), (List)this.batchMessageMap.get((Object)tx.getTransactionId()));
            }
            ArrayList<Message> batchMessages = new ArrayList<Message>();
            for (int index = 0; index < this.maxBatchSize; ++index) {
                Message msg = this.queue.poll();
                if (msg == null) {
                    Utils.sleep((long)50L);
                    break;
                }
                try {
                    if (TridentJmsSpout.this.jmsAcknowledgeMode != 1) {
                        batchMessages.add(msg);
                    }
                    Values tuple = TridentJmsSpout.this.tupleProducer.toTuple(msg);
                    collector.emit((List)tuple);
                    continue;
                }
                catch (JMSException e) {
                    this.LOG.warn("Failed to emit message, could not retrieve data for " + this.name + ": " + (Object)((Object)e));
                }
            }
            if (!batchMessages.isEmpty()) {
                this.LOG.debug("Emitting batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " and size " + batchMessages.size() + " for " + this.name);
            } else {
                this.LOG.trace("No items to acknowledge for batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
            }
            this.batchMessageMap.put((Object)tx.getTransactionId(), batchMessages);
        }

        public void onMessage(Message msg) {
            try {
                this.LOG.trace("Queuing msg [" + msg.getJMSMessageID() + "]");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.queue.offer(msg);
        }
    }
}

