/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jms.spout;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.storm.jms.JmsProvider;
import org.apache.storm.jms.JmsTupleProducer;
import org.apache.storm.jms.spout.JmsMessageID;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSpout
extends BaseRichSpout
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsSpout.class);
    private int jmsAcknowledgeMode = 1;
    private boolean distributed = true;
    private JmsTupleProducer tupleProducer;
    private JmsProvider jmsProvider;
    private LinkedBlockingQueue<Message> queue;
    private TreeSet<JmsMessageID> toCommit;
    private HashMap<JmsMessageID, Message> pendingMessages;
    private long messageSequence = 0L;
    private SpoutOutputCollector collector;
    private transient Connection connection;
    private transient Session session;
    private boolean hasFailures = false;
    public final Serializable recoveryMutex = "RECOVERY_MUTEX";
    private Timer recoveryTimer = null;
    private long recoveryPeriod = -1L;

    public void setJmsAcknowledgeMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Acknowledge mode: " + mode + " (See javax.jms.Session for valid values)");
            }
        }
        this.jmsAcknowledgeMode = mode;
    }

    public int getJmsAcknowledgeMode() {
        return this.jmsAcknowledgeMode;
    }

    public void setJmsProvider(JmsProvider provider) {
        this.jmsProvider = provider;
    }

    public void setJmsTupleProducer(JmsTupleProducer producer) {
        this.tupleProducer = producer;
    }

    public void onMessage(Message msg) {
        try {
            LOG.debug("Queuing msg [" + msg.getJMSMessageID() + "]");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.queue.offer(msg);
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        if (this.jmsProvider == null) {
            throw new IllegalStateException("JMS provider has not been set.");
        }
        if (this.tupleProducer == null) {
            throw new IllegalStateException("JMS Tuple Producer has not been set.");
        }
        Integer topologyTimeout = (Integer)conf.get("topology.message.timeout.secs");
        topologyTimeout = topologyTimeout == null ? 30 : topologyTimeout;
        if ((long)(topologyTimeout * 1000) > this.recoveryPeriod) {
            LOG.warn("*** WARNING *** : Recovery period (" + this.recoveryPeriod + " ms.) is less then the configured 'topology.message.timeout.secs' of " + topologyTimeout + " secs. This could lead to a message replay flood!");
        }
        this.queue = new LinkedBlockingQueue();
        this.toCommit = new TreeSet();
        this.pendingMessages = new HashMap();
        this.collector = collector;
        try {
            ConnectionFactory cf = this.jmsProvider.connectionFactory();
            Destination dest = this.jmsProvider.destination();
            this.connection = cf.createConnection();
            this.session = this.connection.createSession(false, this.jmsAcknowledgeMode);
            MessageConsumer consumer = this.session.createConsumer(dest);
            consumer.setMessageListener((MessageListener)this);
            this.connection.start();
            if (this.isDurableSubscription() && this.recoveryPeriod > 0L) {
                this.recoveryTimer = new Timer();
                this.recoveryTimer.scheduleAtFixedRate((TimerTask)new RecoveryTask(), 10L, this.recoveryPeriod);
            }
        }
        catch (Exception e) {
            LOG.warn("Error creating JMS connection.", (Throwable)e);
        }
    }

    public void close() {
        try {
            LOG.debug("Closing JMS connection.");
            this.session.close();
            this.connection.close();
        }
        catch (JMSException e) {
            LOG.warn("Error closing JMS connection.", (Throwable)e);
        }
    }

    public void nextTuple() {
        Message msg = this.queue.poll();
        if (msg == null) {
            Utils.sleep((long)50L);
        } else {
            LOG.debug("sending tuple: " + msg);
            try {
                Values vals = this.tupleProducer.toTuple(msg);
                LOG.debug("Requested deliveryMode: " + JmsSpout.toDeliveryModeString(msg.getJMSDeliveryMode()));
                LOG.debug("Our deliveryMode: " + JmsSpout.toDeliveryModeString(this.jmsAcknowledgeMode));
                if (this.isDurableSubscription()) {
                    LOG.debug("Requesting acks.");
                    JmsMessageID messageId = new JmsMessageID(this.messageSequence++, msg.getJMSMessageID());
                    this.collector.emit((List)vals, (Object)messageId);
                    this.pendingMessages.put(messageId, msg);
                    this.toCommit.add(messageId);
                } else {
                    this.collector.emit((List)vals);
                }
            }
            catch (JMSException e) {
                LOG.warn("Unable to convert JMS message: " + msg);
            }
        }
    }

    public void ack(Object msgId) {
        Message msg = this.pendingMessages.remove(msgId);
        JmsMessageID oldest = this.toCommit.first();
        if (msgId.equals(oldest)) {
            if (msg != null) {
                try {
                    LOG.debug("Committing...");
                    msg.acknowledge();
                    LOG.debug("JMS Message acked: " + msgId);
                    this.toCommit.remove(msgId);
                }
                catch (JMSException e) {
                    LOG.warn("Error acknowldging JMS message: " + msgId, (Throwable)e);
                }
            } else {
                LOG.warn("Couldn't acknowledge unknown JMS message ID: " + msgId);
            }
        } else {
            this.toCommit.remove(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(Object msgId) {
        LOG.warn("Message failed: " + msgId);
        this.pendingMessages.clear();
        this.toCommit.clear();
        Serializable serializable = this.recoveryMutex;
        synchronized (serializable) {
            this.hasFailures = true;
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.tupleProducer.declareOutputFields(declarer);
    }

    public boolean hasFailures() {
        return this.hasFailures;
    }

    protected void recovered() {
        this.hasFailures = false;
    }

    public void setRecoveryPeriod(long period) {
        this.recoveryPeriod = period;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    private static final String toDeliveryModeString(int deliveryMode) {
        switch (deliveryMode) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN";
    }

    protected Session getSession() {
        return this.session;
    }

    private boolean isDurableSubscription() {
        return this.jmsAcknowledgeMode != 1;
    }

    private class RecoveryTask
    extends TimerTask {
        private final Logger LOG = LoggerFactory.getLogger(RecoveryTask.class);

        private RecoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Serializable serializable = JmsSpout.this.recoveryMutex;
            synchronized (serializable) {
                if (JmsSpout.this.hasFailures()) {
                    try {
                        this.LOG.info("Recovering from a message failure.");
                        JmsSpout.this.getSession().recover();
                        JmsSpout.this.recovered();
                    }
                    catch (JMSException e) {
                        this.LOG.warn("Could not recover jms session.", (Throwable)e);
                    }
                }
            }
        }
    }
}

