/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.trident;

import com.microsoft.eventhubs.client.EventHubEnqueueTimeFilter;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubOffsetFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.trident.ITridentPartitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentPartitionManager
implements ITridentPartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(TridentPartitionManager.class);
    private final int receiveTimeoutMs = 5000;
    private final IEventHubReceiver receiver;
    private final EventHubSpoutConfig spoutConfig;
    private String lastOffset = "-1";

    public TridentPartitionManager(EventHubSpoutConfig spoutConfig, IEventHubReceiver receiver) {
        this.receiver = receiver;
        this.spoutConfig = spoutConfig;
    }

    @Override
    public boolean open(String offset) {
        try {
            if ((offset == null || offset.equals("-1")) && this.spoutConfig.getEnqueueTimeFilter() != 0L) {
                this.receiver.open(new EventHubEnqueueTimeFilter(this.spoutConfig.getEnqueueTimeFilter()));
            } else {
                this.receiver.open(new EventHubOffsetFilter(offset));
            }
            this.lastOffset = offset;
            return true;
        }
        catch (EventHubException ex) {
            logger.error("failed to open eventhub receiver: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public void close() {
        this.receiver.close();
    }

    @Override
    public List<EventData> receiveBatch(String offset, int count) {
        EventData ed;
        ArrayList<EventData> batch = new ArrayList<EventData>(count);
        if (!offset.equals(this.lastOffset) || !this.receiver.isOpen()) {
            this.close();
            if (!this.open(offset)) {
                return batch;
            }
        }
        for (int i = 0; i < count && (ed = this.receiver.receive(5000L)) != null; ++i) {
            batch.add(ed);
            this.lastOffset = ed.getMessageId().getOffset();
        }
        return batch;
    }
}

