/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.storm.eventhubs.spout.IStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperStateStore
implements IStateStore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperStateStore.class);
    private final String zookeeperConnectionString;
    private final CuratorFramework curatorFramework;

    public ZookeeperStateStore(String zookeeperConnectionString) {
        this(zookeeperConnectionString, 3, 100);
    }

    public ZookeeperStateStore(String connectionString, int retries, int retryInterval) {
        this.zookeeperConnectionString = connectionString == null ? "localhost:2181" : connectionString;
        RetryNTimes retryPolicy = new RetryNTimes(retries, retryInterval);
        this.curatorFramework = CuratorFrameworkFactory.newClient(this.zookeeperConnectionString, retryPolicy);
    }

    @Override
    public void open() {
        this.curatorFramework.start();
    }

    @Override
    public void close() {
        this.curatorFramework.close();
    }

    @Override
    public void saveData(String statePath, String data) {
        data = data == null ? "" : data;
        byte[] bytes = data.getBytes();
        try {
            if (this.curatorFramework.checkExists().forPath(statePath) == null) {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(statePath, bytes);
            } else {
                this.curatorFramework.setData().forPath(statePath, bytes);
            }
            logger.info(String.format("data was saved. path: %s, data: %s.", statePath, data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readData(String statePath) {
        try {
            if (this.curatorFramework.checkExists().forPath(statePath) == null) {
                return null;
            }
            byte[] bytes = (byte[])this.curatorFramework.getData().forPath(statePath);
            String data = new String(bytes);
            logger.info(String.format("data was retrieved. path: %s, data: %s.", statePath, data));
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

