/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.IEventHubReceiverFactory;
import org.apache.storm.eventhubs.spout.IPartitionCoordinator;
import org.apache.storm.eventhubs.spout.IPartitionManager;
import org.apache.storm.eventhubs.spout.IPartitionManagerFactory;
import org.apache.storm.eventhubs.spout.IStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticPartitionCoordinator
implements IPartitionCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(StaticPartitionCoordinator.class);
    protected final EventHubSpoutConfig config;
    protected final int taskIndex;
    protected final int totalTasks;
    protected final List<IPartitionManager> partitionManagers;
    protected final Map<String, IPartitionManager> partitionManagerMap;
    protected final IStateStore stateStore;

    public StaticPartitionCoordinator(EventHubSpoutConfig spoutConfig, int taskIndex, int totalTasks, IStateStore stateStore, IPartitionManagerFactory pmFactory, IEventHubReceiverFactory recvFactory) {
        this.config = spoutConfig;
        this.taskIndex = taskIndex;
        this.totalTasks = totalTasks;
        this.stateStore = stateStore;
        List<String> partitionIds = this.calculateParititionIdsToOwn();
        this.partitionManagerMap = new HashMap<String, IPartitionManager>();
        this.partitionManagers = new ArrayList<IPartitionManager>();
        for (String partitionId : partitionIds) {
            IEventHubReceiver receiver = recvFactory.create(this.config, partitionId);
            IPartitionManager partitionManager = pmFactory.create(this.config, partitionId, stateStore, receiver);
            this.partitionManagerMap.put(partitionId, partitionManager);
            this.partitionManagers.add(partitionManager);
        }
    }

    @Override
    public List<IPartitionManager> getMyPartitionManagers() {
        return this.partitionManagers;
    }

    @Override
    public IPartitionManager getPartitionManager(String partitionId) {
        return this.partitionManagerMap.get(partitionId);
    }

    protected List<String> calculateParititionIdsToOwn() {
        ArrayList<String> taskPartitions = new ArrayList<String>();
        for (int i = this.taskIndex; i < this.config.getPartitionCount(); i += this.totalTasks) {
            taskPartitions.add(Integer.toString(i));
            logger.info(String.format("taskIndex %d owns partitionId %d.", this.taskIndex, i));
        }
        return taskPartitions;
    }
}

