/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import com.microsoft.eventhubs.client.EventHubEnqueueTimeFilter;
import com.microsoft.eventhubs.client.EventHubOffsetFilter;
import com.microsoft.eventhubs.client.IEventHubFilter;
import java.util.Map;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.IPartitionManager;
import org.apache.storm.eventhubs.spout.IStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePartitionManager
implements IPartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(SimplePartitionManager.class);
    private static final String statePathPrefix = "/eventhubspout";
    protected final IEventHubReceiver receiver;
    protected String lastOffset = "-1";
    protected String committedOffset = "-1";
    protected final EventHubSpoutConfig config;
    private final String partitionId;
    private final IStateStore stateStore;
    private final String statePath;

    public SimplePartitionManager(EventHubSpoutConfig spoutConfig, String partitionId, IStateStore stateStore, IEventHubReceiver receiver) {
        this.receiver = receiver;
        this.config = spoutConfig;
        this.partitionId = partitionId;
        this.statePath = this.getPartitionStatePath();
        this.stateStore = stateStore;
    }

    @Override
    public void open() throws Exception {
        String offset = this.stateStore.readData(this.statePath);
        logger.info("read offset from state store: " + offset);
        if (offset == null) {
            offset = "-1";
        }
        IEventHubFilter filter = offset.equals("-1") && this.config.getEnqueueTimeFilter() != 0L ? new EventHubEnqueueTimeFilter(this.config.getEnqueueTimeFilter()) : new EventHubOffsetFilter(offset);
        this.receiver.open(filter);
    }

    @Override
    public void close() {
        this.receiver.close();
        this.checkpoint();
    }

    @Override
    public void checkpoint() {
        String completedOffset = this.getCompletedOffset();
        if (!this.committedOffset.equals(completedOffset)) {
            logger.info("saving state " + completedOffset);
            this.stateStore.saveData(this.statePath, completedOffset);
            this.committedOffset = completedOffset;
        }
    }

    protected String getCompletedOffset() {
        return this.lastOffset;
    }

    @Override
    public EventData receive() {
        EventData eventData = this.receiver.receive(5000L);
        if (eventData != null) {
            this.lastOffset = eventData.getMessageId().getOffset();
        }
        return eventData;
    }

    @Override
    public void ack(String offset) {
    }

    @Override
    public void fail(String offset) {
        logger.warn("fail on " + offset);
    }

    private String getPartitionStatePath() {
        String namespace = this.config.getNamespace();
        String entityPath = this.config.getEntityPath();
        String topologyName = this.config.getTopologyName();
        String partitionStatePath = "/eventhubspout/" + topologyName + "/" + namespace + "/" + entityPath + "/partitions/" + this.partitionId;
        logger.info("partition state path: " + partitionStatePath);
        return partitionStatePath;
    }

    @Override
    public Map getMetricsData() {
        return this.receiver.getMetricsData();
    }
}

