/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.IStateStore;
import org.apache.storm.eventhubs.spout.SimplePartitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager
extends SimplePartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(PartitionManager.class);
    private final int ehReceiveTimeoutMs = 5000;
    private final Map<String, EventData> pending = new LinkedHashMap<String, EventData>();
    private final TreeSet<EventData> toResend = new TreeSet();

    public PartitionManager(EventHubSpoutConfig spoutConfig, String partitionId, IStateStore stateStore, IEventHubReceiver receiver) {
        super(spoutConfig, partitionId, stateStore, receiver);
    }

    @Override
    public EventData receive() {
        if (this.pending.size() >= this.config.getMaxPendingMsgsPerPartition()) {
            return null;
        }
        EventData eventData = this.toResend.isEmpty() ? this.receiver.receive(5000L) : this.toResend.pollFirst();
        if (eventData != null) {
            this.lastOffset = eventData.getMessageId().getOffset();
            this.pending.put(this.lastOffset, eventData);
        }
        return eventData;
    }

    @Override
    public void ack(String offset) {
        this.pending.remove(offset);
    }

    @Override
    public void fail(String offset) {
        logger.warn("fail on " + offset);
        EventData eventData = this.pending.remove(offset);
        this.toResend.add(eventData);
    }

    @Override
    protected String getCompletedOffset() {
        String offset = null;
        if (this.pending.size() > 0) {
            offset = this.pending.keySet().iterator().next();
        }
        if (this.toResend.size() > 0) {
            String offset2 = this.toResend.first().getMessageId().getOffset();
            if (offset == null || offset2.compareTo(offset) < 0) {
                offset = offset2;
            }
        }
        if (offset == null) {
            offset = this.lastOffset;
        }
        return offset;
    }
}

