/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import com.microsoft.eventhubs.client.ConnectionStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.eventhubs.spout.IEventDataScheme;
import org.apache.storm.eventhubs.spout.StringEventDataScheme;

public class EventHubSpoutConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EH_SERVICE_FQDN_SUFFIX = "servicebus.windows.net";
    private final String userName;
    private final String password;
    private final String namespace;
    private final String entityPath;
    private final int partitionCount;
    private String zkConnectionString = null;
    private int checkpointIntervalInSeconds = 10;
    private int receiverCredits = 1024;
    private int maxPendingMsgsPerPartition = 1024;
    private long enqueueTimeFilter = 0L;
    private String connectionString;
    private String topologyName;
    private IEventDataScheme scheme = new StringEventDataScheme();
    private String consumerGroupName = null;

    public EventHubSpoutConfig(String username, String password, String namespace, String entityPath, int partitionCount) {
        this.userName = username;
        this.password = password;
        this.connectionString = new ConnectionStringBuilder(username, password, namespace).getConnectionString();
        this.namespace = namespace;
        this.entityPath = entityPath;
        this.partitionCount = partitionCount;
    }

    public EventHubSpoutConfig(String username, String password, String namespace, String entityPath, int partitionCount, String zkConnectionString) {
        this(username, password, namespace, entityPath, partitionCount);
        this.setZkConnectionString(zkConnectionString);
    }

    public EventHubSpoutConfig(String username, String password, String namespace, String entityPath, int partitionCount, String zkConnectionString, int checkpointIntervalInSeconds, int receiverCredits) {
        this(username, password, namespace, entityPath, partitionCount, zkConnectionString);
        this.setCheckpointIntervalInSeconds(checkpointIntervalInSeconds);
        this.setReceiverCredits(receiverCredits);
    }

    public EventHubSpoutConfig(String username, String password, String namespace, String entityPath, int partitionCount, String zkConnectionString, int checkpointIntervalInSeconds, int receiverCredits, long enqueueTimeFilter) {
        this(username, password, namespace, entityPath, partitionCount, zkConnectionString, checkpointIntervalInSeconds, receiverCredits);
        this.setEnqueueTimeFilter(enqueueTimeFilter);
    }

    public EventHubSpoutConfig(String username, String password, String namespace, String entityPath, int partitionCount, String zkConnectionString, int checkpointIntervalInSeconds, int receiverCredits, int maxPendingMsgsPerPartition, long enqueueTimeFilter) {
        this(username, password, namespace, entityPath, partitionCount, zkConnectionString, checkpointIntervalInSeconds, receiverCredits);
        this.setMaxPendingMsgsPerPartition(maxPendingMsgsPerPartition);
        this.setEnqueueTimeFilter(enqueueTimeFilter);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public String getZkConnectionString() {
        return this.zkConnectionString;
    }

    public void setZkConnectionString(String value) {
        this.zkConnectionString = value;
    }

    public EventHubSpoutConfig withZkConnectionString(String value) {
        this.setZkConnectionString(value);
        return this;
    }

    public int getCheckpointIntervalInSeconds() {
        return this.checkpointIntervalInSeconds;
    }

    public void setCheckpointIntervalInSeconds(int value) {
        this.checkpointIntervalInSeconds = value;
    }

    public EventHubSpoutConfig withCheckpointIntervalInSeconds(int value) {
        this.setCheckpointIntervalInSeconds(value);
        return this;
    }

    public int getReceiverCredits() {
        return this.receiverCredits;
    }

    public void setReceiverCredits(int value) {
        this.receiverCredits = value;
    }

    public EventHubSpoutConfig withReceiverCredits(int value) {
        this.setReceiverCredits(value);
        return this;
    }

    public int getMaxPendingMsgsPerPartition() {
        return this.maxPendingMsgsPerPartition;
    }

    public void setMaxPendingMsgsPerPartition(int value) {
        this.maxPendingMsgsPerPartition = value;
    }

    public EventHubSpoutConfig withMaxPendingMsgsPerPartition(int value) {
        this.setMaxPendingMsgsPerPartition(value);
        return this;
    }

    public long getEnqueueTimeFilter() {
        return this.enqueueTimeFilter;
    }

    public void setEnqueueTimeFilter(long value) {
        this.enqueueTimeFilter = value;
    }

    public EventHubSpoutConfig withEnqueueTimeFilter(long value) {
        this.setEnqueueTimeFilter(value);
        return this;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String value) {
        this.topologyName = value;
    }

    public EventHubSpoutConfig withTopologyName(String value) {
        this.setTopologyName(value);
        return this;
    }

    public IEventDataScheme getEventDataScheme() {
        return this.scheme;
    }

    public void setEventDataScheme(IEventDataScheme scheme) {
        this.scheme = scheme;
    }

    public EventHubSpoutConfig withEventDataScheme(IEventDataScheme value) {
        this.setEventDataScheme(value);
        return this;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public void setConsumerGroupName(String value) {
        this.consumerGroupName = value;
    }

    public EventHubSpoutConfig withConsumerGroupName(String value) {
        this.setConsumerGroupName(value);
        return this;
    }

    public List<String> getPartitionList() {
        ArrayList<String> partitionList = new ArrayList<String>();
        for (int i = 0; i < this.partitionCount; ++i) {
            partitionList.add(Integer.toString(i));
        }
        return partitionList;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setTargetAddress(String targetFqnAddress) {
        this.connectionString = new ConnectionStringBuilder(this.userName, this.password, this.namespace, targetFqnAddress).getConnectionString();
    }

    public EventHubSpoutConfig withTargetAddress(String targetFqnAddress) {
        this.setTargetAddress(targetFqnAddress);
        return this;
    }
}

