/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.IEventHubFilter;
import com.microsoft.eventhubs.client.ResilientEventHubReceiver;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.MessageId;
import org.apache.storm.metric.api.CountMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.MeanReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubReceiverImpl
implements IEventHubReceiver {
    private static final Logger logger = LoggerFactory.getLogger(EventHubReceiverImpl.class);
    private static final Symbol OffsetKey = Symbol.valueOf("x-opt-offset");
    private static final Symbol SequenceNumberKey = Symbol.valueOf("x-opt-sequence-number");
    private final String connectionString;
    private final String entityName;
    private final String partitionId;
    private final int defaultCredits;
    private final String consumerGroupName;
    private ResilientEventHubReceiver receiver;
    private ReducedMetric receiveApiLatencyMean;
    private CountMetric receiveApiCallCount;
    private CountMetric receiveMessageCount;

    public EventHubReceiverImpl(EventHubSpoutConfig config, String partitionId) {
        this.connectionString = config.getConnectionString();
        this.entityName = config.getEntityPath();
        this.defaultCredits = config.getReceiverCredits();
        this.partitionId = partitionId;
        this.consumerGroupName = config.getConsumerGroupName();
        this.receiveApiLatencyMean = new ReducedMetric((IReducer)new MeanReducer());
        this.receiveApiCallCount = new CountMetric();
        this.receiveMessageCount = new CountMetric();
    }

    @Override
    public void open(IEventHubFilter filter) throws EventHubException {
        logger.info("creating eventhub receiver: partitionId=" + this.partitionId + ", filterString=" + filter.getFilterString());
        long start = System.currentTimeMillis();
        this.receiver = new ResilientEventHubReceiver(this.connectionString, this.entityName, this.partitionId, this.consumerGroupName, this.defaultCredits, filter);
        this.receiver.initialize();
        long end = System.currentTimeMillis();
        logger.info("created eventhub receiver, time taken(ms): " + (end - start));
    }

    @Override
    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
            logger.info("closed eventhub receiver: partitionId=" + this.partitionId);
            this.receiver = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.receiver != null;
    }

    @Override
    public EventData receive(long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        Message message = this.receiver.receive(timeoutInMilliseconds);
        long end = System.currentTimeMillis();
        long millis = end - start;
        this.receiveApiLatencyMean.update((Object)millis);
        this.receiveApiCallCount.incr();
        if (message == null) {
            return null;
        }
        this.receiveMessageCount.incr();
        MessageId messageId = this.createMessageId(message);
        return EventData.create(message, messageId);
    }

    private MessageId createMessageId(Message message) {
        String offset = null;
        long sequenceNumber = 0L;
        for (Section section : message.getPayload()) {
            if (!(section instanceof MessageAnnotations)) continue;
            MessageAnnotations annotations = (MessageAnnotations)section;
            HashMap annonationMap = (HashMap)annotations.getValue();
            if (annonationMap.containsKey(OffsetKey)) {
                offset = (String)annonationMap.get(OffsetKey);
            }
            if (!annonationMap.containsKey(SequenceNumberKey)) continue;
            sequenceNumber = (Long)annonationMap.get(SequenceNumberKey);
        }
        return MessageId.create(this.partitionId, offset, sequenceNumber);
    }

    @Override
    public Map getMetricsData() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(this.partitionId + "/receiveApiLatencyMean", this.receiveApiLatencyMean.getValueAndReset());
        ret.put(this.partitionId + "/receiveApiCallCount", this.receiveApiCallCount.getValueAndReset());
        ret.put(this.partitionId + "/receiveMessageCount", this.receiveMessageCount.getValueAndReset());
        return ret;
    }
}

