/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.samples;

import org.apache.storm.eventhubs.samples.EventCount;
import org.apache.storm.eventhubs.spout.EventHubSpout;
import org.apache.storm.eventhubs.trident.TransactionalTridentEventHubSpout;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.BaseFilter;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Filter;
import org.apache.storm.trident.operation.builtin.Count;
import org.apache.storm.trident.operation.builtin.Sum;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.testing.MemoryMapState;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTridentEventCount
extends EventCount {
    @Override
    protected StormTopology buildTopology(EventHubSpout eventHubSpout) {
        TridentTopology topology = new TridentTopology();
        TransactionalTridentEventHubSpout spout = new TransactionalTridentEventHubSpout(this.spoutConfig);
        TridentState state = topology.newStream("stream-" + this.spoutConfig.getTopologyName(), (IPartitionedTridentSpout)spout).parallelismHint(this.spoutConfig.getPartitionCount()).aggregate((CombinerAggregator)new Count(), new Fields(new String[]{"partial-count"})).persistentAggregate((StateFactory)new MemoryMapState.Factory(), new Fields(new String[]{"partial-count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"count"}));
        state.newValuesStream().each(new Fields(new String[]{"count"}), (Filter)new LoggingFilter("got count: ", 10000));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        TransactionalTridentEventCount scenario = new TransactionalTridentEventCount();
        scenario.runScenario(args);
    }

    public static class LoggingFilter
    extends BaseFilter {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = LoggerFactory.getLogger(LoggingFilter.class);
        private final String prefix;
        private final long logIntervalMs;
        private long lastTime;

        public LoggingFilter(String prefix, int logIntervalMs) {
            this.prefix = prefix;
            this.logIntervalMs = logIntervalMs;
            this.lastTime = System.nanoTime();
        }

        public boolean isKeep(TridentTuple tuple) {
            long now = System.nanoTime();
            if (this.logIntervalMs < (now - this.lastTime) / 1000000L) {
                logger.info(this.prefix + tuple.toString());
                this.lastTime = now;
            }
            return false;
        }
    }
}

