/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.samples;

import org.apache.storm.eventhubs.samples.EventCount;
import org.apache.storm.eventhubs.samples.TransactionalTridentEventCount;
import org.apache.storm.eventhubs.spout.EventHubSpout;
import org.apache.storm.eventhubs.trident.OpaqueTridentEventHubSpout;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Filter;
import org.apache.storm.trident.operation.builtin.Count;
import org.apache.storm.trident.operation.builtin.Sum;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.testing.MemoryMapState;
import org.apache.storm.tuple.Fields;

public class OpaqueTridentEventCount
extends EventCount {
    @Override
    protected StormTopology buildTopology(EventHubSpout eventHubSpout) {
        TridentTopology topology = new TridentTopology();
        OpaqueTridentEventHubSpout spout = new OpaqueTridentEventHubSpout(this.spoutConfig);
        TridentState state = topology.newStream("stream-" + this.spoutConfig.getTopologyName(), (IOpaquePartitionedTridentSpout)spout).parallelismHint(this.spoutConfig.getPartitionCount()).aggregate((CombinerAggregator)new Count(), new Fields(new String[]{"partial-count"})).persistentAggregate((StateFactory)new MemoryMapState.Factory(), new Fields(new String[]{"partial-count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"count"}));
        state.newValuesStream().each(new Fields(new String[]{"count"}), (Filter)new TransactionalTridentEventCount.LoggingFilter("got count: ", 10000));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        OpaqueTridentEventCount scenario = new OpaqueTridentEventCount();
        scenario.runScenario(args);
    }
}

