/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.transport.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class TransferWriter
extends AbstractDescribedTypeWriter<Transfer> {
    private Transfer _value;
    private int _count = -1;
    private static ValueWriter.Factory<Transfer> FACTORY = new ValueWriter.Factory<Transfer>(){

        @Override
        public ValueWriter<Transfer> newInstance(ValueWriter.Registry registry) {
            return new TransferWriter(registry);
        }
    };

    public TransferWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Transfer value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getBatchable() != null) {
            return 11;
        }
        if (this._value.getAborted() != null) {
            return 10;
        }
        if (this._value.getResume() != null) {
            return 9;
        }
        if (this._value.getState() != null) {
            return 8;
        }
        if (this._value.getRcvSettleMode() != null) {
            return 7;
        }
        if (this._value.getMore() != null) {
            return 6;
        }
        if (this._value.getSettled() != null) {
            return 5;
        }
        if (this._value.getMessageFormat() != null) {
            return 4;
        }
        if (this._value.getDeliveryTag() != null) {
            return 3;
        }
        if (this._value.getDeliveryId() != null) {
            return 2;
        }
        if (this._value.getHandle() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(20L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Transfer.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Transfer> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Transfer value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return TransferWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < TransferWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return TransferWriter.this._value.getHandle();
                }
                case 1: {
                    return TransferWriter.this._value.getDeliveryId();
                }
                case 2: {
                    return TransferWriter.this._value.getDeliveryTag();
                }
                case 3: {
                    return TransferWriter.this._value.getMessageFormat();
                }
                case 4: {
                    return TransferWriter.this._value.getSettled();
                }
                case 5: {
                    return TransferWriter.this._value.getMore();
                }
                case 6: {
                    return TransferWriter.this._value.getRcvSettleMode();
                }
                case 7: {
                    return TransferWriter.this._value.getState();
                }
                case 8: {
                    return TransferWriter.this._value.getResume();
                }
                case 9: {
                    return TransferWriter.this._value.getAborted();
                }
                case 10: {
                    return TransferWriter.this._value.getBatchable();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

