/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class Delivery {
    private boolean _complete;
    private boolean _settled;
    private final List<Transfer> _transfers = new ArrayList<Transfer>(1);
    private final UnsignedInteger _deliveryId;
    private final Binary _deliveryTag;
    private final LinkEndpoint _linkEndpoint;

    public Delivery(Transfer transfer, LinkEndpoint endpoint) {
        this._settled = Boolean.TRUE.equals(transfer.getSettled());
        this._deliveryId = transfer.getDeliveryId();
        this._deliveryTag = transfer.getDeliveryTag();
        this._linkEndpoint = endpoint;
        this.addTransfer(transfer);
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void setComplete(boolean complete) {
        this._complete = complete;
    }

    public boolean isSettled() {
        return this._settled;
    }

    public void setSettled(boolean settled) {
        this._settled = settled;
    }

    public void addTransfer(Transfer transfer) {
        this._transfers.add(transfer);
        if (Boolean.TRUE.equals(transfer.getAborted()) || !Boolean.TRUE.equals(transfer.getMore())) {
            this.setComplete(true);
        }
        if (Boolean.TRUE.equals(transfer.getSettled())) {
            this.setSettled(true);
        }
    }

    public List<Transfer> getTransfers() {
        return this._transfers;
    }

    public UnsignedInteger getDeliveryId() {
        return this._deliveryId;
    }

    public LinkEndpoint getLinkEndpoint() {
        return this._linkEndpoint;
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }
}

