/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl.util;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.amqp_1_0.codec.DescribedType;
import org.apache.qpid.amqp_1_0.jms.impl.util.AnnotationEncoder;
import org.apache.qpid.amqp_1_0.jms.impl.util.JsonDecoder;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.UnsignedShort;

public class AnnotationDecoder {
    private static final Map<String, Converter> CONVERTERS = new HashMap<String, Converter>();
    private final JsonDecoder _decoder = new JsonDecoder();
    private static Converter LONG_CONVERTER = new Converter("long"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return ((Number)value).longValue();
        }
    };
    private static Converter SHORT_CONVERTER = new Converter("short"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return ((Number)value).shortValue();
        }
    };
    private static Converter BYTE_CONVERTER = new Converter("byte"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return ((Number)value).byteValue();
        }
    };
    private static Converter ULONG_CONVERTER = new Converter("ulong"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Number number = (Number)value;
            return UnsignedLong.valueOf(number.toString());
        }
    };
    private static Converter UINT_CONVERTER = new Converter("uint"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return UnsignedInteger.valueOf(((Number)value).longValue());
        }
    };
    private static Converter USHORT_CONVERTER = new Converter("ushort"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Number number = (Number)value;
            return UnsignedShort.valueOf(number.toString());
        }
    };
    private static Converter UBYTE_CONVERTER = new Converter("ubyte"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Number number = (Number)value;
            return UnsignedByte.valueOf(value.toString());
        }
    };
    private static Converter FLOAT_CONVERTER = new Converter("float"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return Float.valueOf(((Number)value).floatValue());
        }
    };
    private static Converter DOUBLE_CONVERTER = new Converter("double"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return ((Number)value).doubleValue();
        }
    };
    private static Converter SYMBOL_CONVERTER = new Converter("symbol"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return Symbol.valueOf((String)value);
        }
    };
    private static Converter CHAR_CONVERTER = new Converter("char"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            String stringValue = (String)value;
            if (stringValue.length() != 1) {
                throw new IllegalArgumentException("Cannot decode '" + stringValue + "' as a char");
            }
            return Character.valueOf(stringValue.charAt(0));
        }
    };
    private static Converter TIMESTAMP_CONVERTER = new Converter("timestamp"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            return new Date(((Number)value).longValue());
        }
    };
    private static Converter MAP_CONVERTER = new Converter("map"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Map map = (Map)value;
            LinkedHashMap<Object, Object> convertedMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                convertedMap.put(decoder.convertObject(entry.getKey()), decoder.convertObject(entry.getValue()));
            }
            return convertedMap;
        }
    };
    private static Converter DESCRIBED_CONVERTER = new Converter("described"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Map map = (Map)value;
            if (map.size() != 1) {
                throw new IllegalArgumentException("Cannot convert described type from: " + map);
            }
            Object descriptor = decoder.convertObject(map.keySet().iterator().next());
            Object described = decoder.convertObject(map.values().iterator().next());
            return new DescribedType(descriptor, described);
        }
    };
    private static Converter BINARY_CONVERTER = new Converter("binary"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            String valueString = (String)value;
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)valueString);
            return new Binary(bytes);
        }
    };
    private static Converter ARRAY_CONVERTER = new Converter("array"){

        @Override
        Object convert(Object value, AnnotationDecoder decoder) {
            Object[] array;
            Collection list = (Collection)value;
            ArrayList<Object> convertedList = new ArrayList<Object>(list.size());
            HashSet<Class<Void>> objClasses = new HashSet<Class<Void>>();
            for (Object o : list) {
                Object convertObject = decoder.convertObject(o);
                objClasses.add(convertObject == null ? Void.class : convertObject.getClass());
                convertedList.add(convertObject);
            }
            if (objClasses.size() != 1) {
                throw new IllegalArgumentException("Cannot convert object to an array: " + value);
            }
            Class objClass = (Class)objClasses.iterator().next();
            if (objClass == Void.class) {
                return new Void[convertedList.size()];
            }
            if (objClass == Boolean.class) {
                array = new boolean[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = (Boolean)convertedList.get(i);
                }
                return array;
            }
            if (objClass == Byte.class) {
                array = new byte[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = (Byte)convertedList.get(i);
                }
                return array;
            }
            if (objClass == Character.class) {
                array = new char[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = ((Character)convertedList.get(i)).charValue();
                }
                return array;
            }
            if (objClass == Short.class) {
                array = new short[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = (Short)convertedList.get(i);
                }
                return array;
            }
            if (objClass == Integer.class) {
                array = new int[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = (Integer)convertedList.get(i);
                }
                return array;
            }
            if (objClass == Long.class) {
                array = new long[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = ((Long)convertedList.get(i)).longValue();
                }
                return array;
            }
            if (objClass == Float.class) {
                array = new float[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = ((Float)convertedList.get(i)).floatValue();
                }
                return array;
            }
            if (objClass == Double.class) {
                array = new double[convertedList.size()];
                for (int i = 0; i < convertedList.size(); ++i) {
                    array[i] = ((Double)convertedList.get(i)).doubleValue();
                }
                return array;
            }
            return convertedList.toArray((Object[])Array.newInstance(objClass, convertedList.size()));
        }
    };

    public Map<Symbol, Object> decode(String value) throws IOException {
        Map map = (Map)this._decoder.decode(new StringReader(value));
        LinkedHashMap<Symbol, Object> convertedMap = new LinkedHashMap<Symbol, Object>();
        for (Map.Entry entry : map.entrySet()) {
            convertedMap.put(Symbol.valueOf((String)entry.getKey()), this.convertObject(entry.getValue()));
        }
        return convertedMap;
    }

    private Object convertObject(Object value) {
        if (value == null || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            ArrayList<Object> convertedList = new ArrayList<Object>(list.size());
            for (Object o : list) {
                convertedList.add(this.convertObject(o));
            }
            return convertedList;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.size() != 1) {
                throw new IllegalArgumentException("Cannot parse map " + map + " as a value");
            }
            Converter converter = CONVERTERS.get(map.keySet().iterator().next());
            return converter.convert(map.values().iterator().next(), this);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<Symbol, Object> foo = new LinkedHashMap<Symbol, Object>();
        foo.put(Symbol.valueOf("ARG_1"), 2);
        foo.put(Symbol.valueOf("ARG_2"), true);
        foo.put(Symbol.valueOf("ARG_3"), "wibble");
        foo.put(Symbol.valueOf("ARG_4"), Arrays.asList("this", "is", "a", "test"));
        foo.put(Symbol.valueOf("ARG_5"), Arrays.asList("this", 2L, Symbol.valueOf("a"), "test"));
        foo.put(Symbol.valueOf("ARG_6"), Collections.singletonMap("wibble", 0.3));
        String encoded = new AnnotationEncoder().encode(foo);
        System.err.println(encoded);
        Map<Symbol, Object> foo2 = new AnnotationDecoder().decode(encoded);
        System.out.println(((Object)foo2).equals(foo));
    }

    private static abstract class Converter {
        Converter(String name) {
            CONVERTERS.put(name, this);
        }

        abstract Object convert(Object var1, AnnotationDecoder var2);
    }
}

