/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.amqp_1_0.jms.TextMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class TextMessageImpl
extends MessageImpl
implements TextMessage {
    private String _text;

    protected TextMessageImpl(Header header, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, String text, Footer footer, SessionImpl session) {
        super(header, deliveryAnnotations, messageAnnotations, properties, appProperties, footer, session);
        this._text = text;
    }

    protected TextMessageImpl(SessionImpl session) {
        super(new Header(), new DeliveryAnnotations(new HashMap()), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
    }

    public void setText(String text) throws MessageNotWriteableException {
        if (this.isReadOnly()) {
            throw new MessageNotWriteableException("Cannot set object, message is in read only mode");
        }
        this._text = text;
    }

    public String getText() throws JMSException {
        return this._text;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._text = null;
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add(this.getHeader());
        if (this.getDeliveryAnnotations() != null && this.getDeliveryAnnotations().getValue() != null && !this.getDeliveryAnnotations().getValue().isEmpty()) {
            sections.add(this.getDeliveryAnnotations());
        }
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add(this.getMessageAnnotations());
        }
        sections.add(this.getProperties());
        sections.add(this.getApplicationProperties());
        AmqpValue section = new AmqpValue(this._text);
        sections.add(section);
        sections.add(this.getFooter());
        return sections;
    }
}

