/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.amqp_1_0.jms.MapMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private Map _map;

    public MapMessageImpl(Header header, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, Map map, Footer footer, SessionImpl session) {
        super(header, deliveryAnnotations, messageAnnotations, properties, appProperties, footer, session);
        this._map = map;
    }

    MapMessageImpl(SessionImpl session) {
        super(new Header(), new DeliveryAnnotations(new HashMap()), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
        this._map = new HashMap();
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String || value == null) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to boolean.");
    }

    public byte getByte(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String || value == null) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to byte.");
    }

    public short getShort(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String || value == null) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to short.");
    }

    public char getChar(String name) throws JMSException {
        Object value = this.get(name);
        if (!this.itemExists(name)) {
            throw new MessageFormatException("Property " + name + " not present");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value == null) {
            throw new NullPointerException("Property " + name + " has null value and therefore cannot " + "be converted to char.");
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to boolan.");
    }

    public int getInt(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value == null) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to int.");
    }

    public long getLong(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value == null) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to long.");
    }

    public float getFloat(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to float.");
    }

    public double getDouble(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String || value == null) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to double.");
    }

    public String getString(String name) throws JMSException {
        Object value = this.get(name);
        if (value instanceof String || value == null) {
            return (String)value;
        }
        if (value instanceof byte[] || value instanceof Binary) {
            throw new MessageFormatException("Property " + name + " of type byte[] " + "cannot be converted to String.");
        }
        return value.toString();
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = this.get(name);
        if (!this.itemExists(name)) {
            throw new MessageFormatException("Property " + name + " not present");
        }
        if (value instanceof byte[] || value == null) {
            return (byte[])value;
        }
        if (value instanceof Binary) {
            return ((Binary)value).getArray();
        }
        throw new MessageFormatException("Property " + name + " of type " + value.getClass().getName() + " cannot be converted to byte[].");
    }

    public Object getObject(String s) throws JMSException {
        Object val = this.get(s);
        return val instanceof Binary ? (Object)((Binary)val).getArray() : val;
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.keySet());
    }

    public void setBoolean(String name, boolean val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setByte(String name, byte val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setShort(String name, short val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setChar(String name, char val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, Character.valueOf(val));
    }

    public void setInt(String name, int val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setLong(String name, long val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setFloat(String name, float val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, Float.valueOf(val));
    }

    public void setDouble(String name, double val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setString(String name, String val) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        this.put(name, val);
    }

    public void setBytes(String name, byte[] val) throws JMSException {
        this.setBytes(name, val, 0, val == null ? 0 : val.length);
    }

    public void setBytes(String name, byte[] bytes, int offset, int length) throws JMSException {
        byte[] val;
        this.checkWritable();
        this.checkPropertyName(name);
        if (bytes == null) {
            val = null;
        } else {
            val = new byte[length];
            System.arraycopy(bytes, offset, val, 0, length);
        }
        this.put(name, new Binary(val));
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(name);
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[] || value == null)) {
            throw new MessageFormatException("Cannot set property " + name + " to value " + value + "of type " + value.getClass().getName() + ".");
        }
        this.put(name, value);
    }

    public boolean itemExists(String s) {
        return this._map.containsKey(s);
    }

    @Override
    public Object get(Object key) {
        return this._map.get(key);
    }

    @Override
    public Object put(Object key, Object val) {
        return this._map.put(key, val);
    }

    @Override
    public boolean itemExists(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public Set<Object> keySet() {
        return this._map.keySet();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._map.clear();
    }

    private void checkPropertyName(String propName) {
        if (propName == null || propName.equals("")) {
            throw new IllegalArgumentException("Property name cannot be null, or the empty String.");
        }
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add(this.getHeader());
        if (this.getDeliveryAnnotations() != null && this.getDeliveryAnnotations().getValue() != null && !this.getDeliveryAnnotations().getValue().isEmpty()) {
            sections.add(this.getDeliveryAnnotations());
        }
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add(this.getMessageAnnotations());
        }
        sections.add(this.getProperties());
        sections.add(this.getApplicationProperties());
        sections.add(new AmqpValue(this._map));
        sections.add(this.getFooter());
        return sections;
    }
}

