/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.qpid.amqp_1_0.client.SSLOptions;
import org.apache.qpid.amqp_1_0.client.SSLUtil;
import org.apache.qpid.amqp_1_0.jms.ConnectionFactory;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;

public class ConnectionFactoryImpl
implements ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory {
    private final String _protocol;
    private String _host;
    private int _port;
    private String _username;
    private String _password;
    private String _clientId;
    private String _remoteHost;
    private boolean _ssl;
    private String _queuePrefix;
    private String _topicPrefix;
    private boolean _useBinaryMessageId = Boolean.parseBoolean(System.getProperty("qpid.use_binary_message_id", "true"));
    private Boolean _syncPublish;
    private int _maxSessions = Integer.getInteger("qpid.max_sessions", 0);
    private int _maxPrefetch;
    private String _keyStorePath;
    private String _keyStorePassword;
    private String _keyStoreCertAlias;
    private String _trustStorePath;
    private String _trustStorePassword;
    private String _sslContextProtocol;
    private String _sslContextProvider;
    private String _sslEnabledProtocols;
    private String _sslDisabledProtocols;
    private SSLContext _sslContext;
    private SSLOptions _sslOptions;
    private static final OptionSetter[] _options = new OptionSetter[]{new OptionSetter("clientid", "JMS client id / AMQP container id"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.clientId = value;
        }
    }, new OptionSetter("ssl", "Set to \"true\" to use SSL encryption"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.ssl = Boolean.valueOf(value);
        }
    }, new OptionSetter("remote-host", "AMQP remote host"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.remoteHost = value;
        }
    }, new OptionSetter("binary-messageid", "Use binary (rather than String) message ids"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.binaryMessageId = Boolean.parseBoolean(value);
        }
    }, new OptionSetter("sync-publish", "Wait for acknowledge when sending messages"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.syncPublish = "".equals(value) || "default".equals(value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
        }
    }, new OptionSetter("max-sessions", "set maximum number of sessions allowed"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.maxSessions = Integer.parseInt(value);
        }
    }, new OptionSetter("max-prefetch", "set maximum number of messages prefetched on a link"){

        @Override
        public void setOption(ConnectionOptions options, String value) {
            options.maxPrefetch = Integer.parseInt(value);
        }
    }, new OptionSetter("trust-store", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.trustStorePath = value;
        }
    }, new OptionSetter("trust-store-password", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.trustStorePassword = value;
        }
    }, new OptionSetter("key-store", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.keyStorePath = value;
        }
    }, new OptionSetter("key-store-password", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.keyStorePassword = value;
        }
    }, new OptionSetter("ssl-cert-alias", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.keyStoreCertAlias = value;
        }
    }, new OptionSetter("ssl-context-provider", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.sslContextProvider = value;
        }
    }, new OptionSetter("ssl-context-protocol", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.sslContextProtocol = value;
        }
    }, new OptionSetter("ssl-enabled-protocols", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.sslEnabledProtocols = value;
        }
    }, new OptionSetter("ssl-disabled-protocols", ""){

        @Override
        public void setOption(ConnectionOptions options, String value) throws MalformedURLException {
            options.sslDisabledProtocols = value;
        }
    }};

    public ConnectionFactoryImpl(String host, int port, String username, String password) {
        this(host, port, username, password, null, false);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId) {
        this(host, port, username, password, clientId, false);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, boolean ssl) {
        this(host, port, username, password, clientId, null, ssl);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl) {
        this(host, port, username, password, clientId, remoteHost, ssl, 0);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl, int maxSessions) {
        this(ssl ? "amqps" : "amqp", host, port, username, password, clientId, remoteHost, ssl, maxSessions);
    }

    public ConnectionFactoryImpl(String protocol, String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl, int maxSessions) {
        this._protocol = protocol;
        this._host = host;
        this._port = port;
        this._username = username;
        this._password = password;
        this._clientId = clientId;
        this._remoteHost = remoteHost;
        this._ssl = ssl;
        this._maxSessions = maxSessions;
        if (System.getProperties().containsKey("qpid.sync_publish")) {
            this._syncPublish = Boolean.getBoolean("qpid.sync_publish");
        }
    }

    @Override
    public ConnectionImpl createConnection() throws JMSException {
        return this.createConnection(this._username, this._password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionImpl createConnection(String username, String password) throws JMSException {
        ConnectionFactoryImpl connectionFactoryImpl = this;
        synchronized (connectionFactoryImpl) {
            if (this._ssl && this._sslContext == null) {
                try {
                    X509Certificate[] certs;
                    this._sslContext = SSLUtil.buildSslContext(this._keyStoreCertAlias, this._keyStorePath, KeyStore.getDefaultType(), this._keyStorePassword, KeyManagerFactory.getDefaultAlgorithm(), this._trustStorePath, this._trustStorePassword, KeyStore.getDefaultType(), TrustManagerFactory.getDefaultAlgorithm(), this._sslContextProtocol, this._sslContextProvider);
                    if (username == null && this._keyStoreCertAlias != null && (certs = SSLUtil.getClientCertificates(this._keyStoreCertAlias, this._keyStorePath, this._keyStorePassword, KeyStore.getDefaultType(), KeyManagerFactory.getDefaultAlgorithm())) != null && certs.length != 0) {
                        username = certs[0].getSubjectDN().getName();
                    }
                }
                catch (GeneralSecurityException e) {
                    JMSException jmsException = new JMSException("Unable to create SSL context");
                    jmsException.setLinkedException((Exception)e);
                    jmsException.initCause((Throwable)e);
                    throw jmsException;
                }
                catch (IOException e) {
                    JMSException jmsException = new JMSException("Unable to create SSL context");
                    jmsException.setLinkedException((Exception)e);
                    jmsException.initCause((Throwable)e);
                    throw jmsException;
                }
            }
        }
        ConnectionImpl connection = new ConnectionImpl(this._protocol, this._host, this._port, username, password, this._clientId, this._remoteHost, this._sslContext, this._maxSessions);
        connection.setQueuePrefix(this._queuePrefix);
        connection.setTopicPrefix(this._topicPrefix);
        connection.setUseBinaryMessageId(this._useBinaryMessageId);
        connection.setSyncPublish(this._syncPublish);
        connection.setSslOptions(this._sslOptions);
        if (this._maxPrefetch != 0) {
            connection.setMaxPrefetch(this._maxPrefetch);
        }
        return connection;
    }

    public void setMaxPrefetch(int maxPrefetch) {
        this._maxPrefetch = maxPrefetch;
    }

    public void setKeyStorePath(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this._keyStorePassword = keyStorePassword;
    }

    public void setSslContextProtocol(String sslContextProtocol) {
        this._sslContextProtocol = sslContextProtocol;
    }

    public void setSslContextProvider(String sslContextProvider) {
        this._sslContextProvider = sslContextProvider;
    }

    public void setKeyStoreCertAlias(String keyStoreCertAlias) {
        this._keyStoreCertAlias = keyStoreCertAlias;
    }

    public void setTrustStorePath(String trustStorePath) {
        this._trustStorePath = trustStorePath;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this._trustStorePassword = trustStorePassword;
    }

    public static ConnectionFactoryImpl createFromURL(String urlString) throws MalformedURLException {
        URL url = new URL(null, urlString, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                throw new UnsupportedOperationException();
            }
        });
        String protocol = url.getProtocol();
        if (protocol == null || "".equals(protocol)) {
            protocol = "amqp";
        }
        String host = url.getHost();
        int port = url.getPort();
        ConnectionOptions options = new ConnectionOptions();
        if (port == -1) {
            if ("amqps".equals(protocol)) {
                port = 5671;
                options.ssl = true;
            } else if ("amqp".equals(protocol)) {
                port = 5672;
            } else if ("ws".equals(protocol)) {
                port = 80;
            } else if ("wss".equals(protocol)) {
                port = 443;
            }
        } else if ("amqps".equals(protocol) || "wss".equals(protocol)) {
            options.ssl = true;
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            String[] components = userInfo.split(":", 2);
            options.username = URLDecoder.decode(components[0]);
            if (components.length == 2) {
                options.password = URLDecoder.decode(components[1]);
            }
        }
        if (System.getProperties().containsKey("qpid.sync_publish")) {
            options.syncPublish = Boolean.getBoolean("qpid.sync_publish");
        }
        OptionSetter.parseOptions(url, options);
        if (options.remoteHost == null) {
            options.remoteHost = host;
        }
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(protocol, host, port, options.username, options.password, options.clientId, options.remoteHost, options.ssl, options.maxSessions);
        connectionFactory.setUseBinaryMessageId(options.binaryMessageId);
        connectionFactory.setSyncPublish(options.syncPublish);
        if (options.maxPrefetch != 0) {
            connectionFactory.setMaxPrefetch(options.maxPrefetch);
        }
        if (options.keyStorePath != null) {
            connectionFactory.setKeyStorePath(options.keyStorePath);
        }
        if (options.keyStorePassword != null) {
            connectionFactory.setKeyStorePassword(options.keyStorePassword);
        }
        if (options.keyStoreCertAlias != null) {
            connectionFactory.setKeyStoreCertAlias(options.keyStoreCertAlias);
        }
        if (options.trustStorePath != null) {
            connectionFactory.setTrustStorePath(options.trustStorePath);
        }
        if (options.trustStorePassword != null) {
            connectionFactory.setTrustStorePassword(options.trustStorePassword);
        }
        if (options.sslContextProvider != null) {
            connectionFactory.setSslContextProvider(options.sslContextProvider);
        }
        if (options.sslContextProtocol != null) {
            connectionFactory.setSslContextProtocol(options.sslContextProtocol);
        }
        if (options.sslEnabledProtocols != null) {
            connectionFactory.setSslEnabledProtocols(options.sslEnabledProtocols);
        }
        if (options.sslDisabledProtocols != null) {
            connectionFactory.setSslDisabledProtocols(options.sslDisabledProtocols);
        }
        return connectionFactory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionImpl connection = this.createConnection();
        connection.setQueueConnection(true);
        return connection;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionImpl connection = this.createConnection(username, password);
        connection.setQueueConnection(true);
        return connection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionImpl connection = this.createConnection();
        connection.setTopicConnection(true);
        return connection;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionImpl connection = this.createConnection(username, password);
        connection.setTopicConnection(true);
        return connection;
    }

    public String getTopicPrefix() {
        return this._topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this._topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this._queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this._queuePrefix = queuePrefix;
    }

    public void setUseBinaryMessageId(boolean useBinaryMessageId) {
        this._useBinaryMessageId = useBinaryMessageId;
    }

    public void setSyncPublish(Boolean syncPublish) {
        this._syncPublish = syncPublish;
    }

    public String getSslContextProvider() {
        return this._sslContextProvider;
    }

    public String getSslContextProtocol() {
        return this._sslContextProtocol;
    }

    public String getTrustStorePassword() {
        return this._trustStorePassword;
    }

    public String getTrustStorePath() {
        return this._trustStorePath;
    }

    public String getKeyStoreCertAlias() {
        return this._keyStoreCertAlias;
    }

    public String getKeyStorePassword() {
        return this._keyStorePassword;
    }

    public String getKeyStorePath() {
        return this._keyStorePath;
    }

    public int getMaxPrefetch() {
        return this._maxPrefetch;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public Boolean getSyncPublish() {
        return this._syncPublish;
    }

    public boolean isUseBinaryMessageId() {
        return this._useBinaryMessageId;
    }

    public boolean isSsl() {
        return this._ssl;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUsername() {
        return this._username;
    }

    public int getPort() {
        return this._port;
    }

    public String getHost() {
        return this._host;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setClientId(String clientId) {
        this._clientId = clientId;
    }

    public void setRemoteHost(String remoteHost) {
        this._remoteHost = remoteHost;
    }

    public void setSsl(boolean ssl) {
        this._ssl = ssl;
    }

    public void setMaxSessions(int maxSessions) {
        this._maxSessions = maxSessions;
    }

    public String getSslEnabledProtocols() {
        return this._sslEnabledProtocols;
    }

    public SSLContext getSslContext() {
        return this._sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    public void setSslEnabledProtocols(String sslEnabledProtocols) {
        this._sslEnabledProtocols = sslEnabledProtocols;
        this._sslOptions = new SSLOptions(this._sslEnabledProtocols, this._sslDisabledProtocols);
    }

    public String getSslDisabledProtocols() {
        return this._sslDisabledProtocols;
    }

    public void setSslDisabledProtocols(String sslDisabledProtocols) {
        this._sslDisabledProtocols = sslDisabledProtocols;
        this._sslOptions = new SSLOptions(this._sslEnabledProtocols, this._sslDisabledProtocols);
    }

    private static abstract class OptionSetter {
        private static final Map<String, OptionSetter> OPTION_SETTER_MAP = new HashMap<String, OptionSetter>();
        private final String _name;
        private final String _description;

        public OptionSetter(String name, String description) {
            OPTION_SETTER_MAP.put(name.toLowerCase(), this);
            this._name = name;
            this._description = description;
        }

        public abstract void setOption(ConnectionOptions var1, String var2) throws MalformedURLException;

        public static void parseOptions(URL url, ConnectionOptions options) throws MalformedURLException {
            String query = url.getQuery();
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] keyValuePair = param.split("=", 2);
                    OptionSetter setter = OPTION_SETTER_MAP.get(keyValuePair[0]);
                    if (setter == null) {
                        throw new MalformedURLException("Unknown URL option: '" + keyValuePair[0] + "' in connection URL");
                    }
                    setter.setOption(options, keyValuePair[1]);
                }
            }
        }
    }

    private static class ConnectionOptions {
        String username;
        String password;
        String clientId;
        String remoteHost;
        boolean binaryMessageId = true;
        Boolean syncPublish;
        int maxSessions;
        public boolean ssl;
        public int maxPrefetch;
        public String trustStorePath;
        public String trustStorePassword;
        public String keyStorePath;
        public String keyStorePassword;
        public String keyStoreCertAlias;
        public String sslContextProvider;
        public String sslContextProtocol;
        public String sslEnabledProtocols;
        public String sslDisabledProtocols;

        private ConnectionOptions() {
        }
    }
}

