/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.qpid.amqp_1_0.jms.AmqpMessage;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class AmqpMessageImpl
extends MessageImpl
implements AmqpMessage {
    private static final List<Section> EMPTY_MESSAGE = Collections.singletonList(new AmqpValue(null));
    private List<Section> _sections;

    protected AmqpMessageImpl(Header header, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties appProperties, List<Section> sections, Footer footer, SessionImpl session) {
        super(header, deliveryAnnotations, messageAnnotations, properties, appProperties, footer, session);
        this._sections = sections;
    }

    protected AmqpMessageImpl(SessionImpl session) {
        super(new Header(), new DeliveryAnnotations(new HashMap()), new MessageAnnotations(new HashMap()), new Properties(), new ApplicationProperties(new HashMap()), new Footer(Collections.EMPTY_MAP), session);
        this._sections = EMPTY_MESSAGE;
    }

    @Override
    public int getSectionCount() {
        return this._sections.size();
    }

    @Override
    public Section getSection(int position) {
        return this._sections.get(position);
    }

    @Override
    public ListIterator<Section> sectionIterator() {
        return this._sections.listIterator();
    }

    @Override
    Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.add(this.getHeader());
        if (this.getDeliveryAnnotations() != null && this.getDeliveryAnnotations().getValue() != null && !this.getDeliveryAnnotations().getValue().isEmpty()) {
            sections.add(this.getDeliveryAnnotations());
        }
        if (this.getMessageAnnotations() != null && this.getMessageAnnotations().getValue() != null && !this.getMessageAnnotations().getValue().isEmpty()) {
            sections.add(this.getMessageAnnotations());
        }
        sections.add(this.getProperties());
        sections.add(this.getApplicationProperties());
        sections.addAll(this._sections);
        sections.add(this.getFooter());
        return sections;
    }
}

