/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.SSLOptions;
import org.apache.qpid.amqp_1_0.client.SSLUtil;
import org.apache.qpid.amqp_1_0.client.TransportProvider;
import org.apache.qpid.amqp_1_0.framing.ConnectionHandler;
import org.apache.qpid.amqp_1_0.framing.ExceptionHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.type.FrameBody;
import org.apache.qpid.amqp_1_0.type.SaslFrameBody;

class TCPTransportProvider
implements TransportProvider {
    private static final Logger RAW_LOGGER = Logger.getLogger("RAW");
    private Socket _socket;
    private final String _transport;
    private int _readTimeout = Integer.getInteger("qpid.connection_read_timeout", 10000);
    private long _readIdleTimeout = Long.getLong("qpid.connection_read_idle_timeout", -1L);
    private final AtomicLong _threadNameIndex = new AtomicLong();

    public TCPTransportProvider(String transport) {
        this._transport = transport;
    }

    @Override
    public void connect(final ConnectionEndpoint conn, String address, int port, SSLContext sslContext, SSLOptions sslOptions, ExceptionHandler exceptionHandler) throws ConnectionException {
        try {
            ConnectionHandler.SequentialBytesSource src;
            if (sslContext != null) {
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(address, port);
                if (sslOptions == null) {
                    SSLUtil.removeSSLv3Support(sslSocket);
                } else {
                    List<String> enabledProtocols = sslOptions.getEnabledProtocols();
                    List<String> disabledProtocols = sslOptions.getDisabledProtocols();
                    if (enabledProtocols != null && !enabledProtocols.isEmpty()) {
                        HashSet<String> supportedSuites = new HashSet<String>(Arrays.asList(sslSocket.getSupportedProtocols()));
                        supportedSuites.retainAll(enabledProtocols);
                        sslSocket.setEnabledProtocols(supportedSuites.toArray(new String[supportedSuites.size()]));
                    }
                    if (disabledProtocols != null && !disabledProtocols.isEmpty()) {
                        HashSet<String> enabledSuites = new HashSet<String>(Arrays.asList(sslSocket.getEnabledProtocols()));
                        enabledSuites.removeAll(disabledProtocols);
                        sslSocket.setEnabledProtocols(enabledSuites.toArray(new String[enabledSuites.size()]));
                    }
                }
                sslSocket.startHandshake();
                conn.setExternalPrincipal(sslSocket.getSession().getLocalPrincipal());
                this._socket = sslSocket;
            } else {
                this._socket = new Socket(address, port);
            }
            this._socket.setSoTimeout(this._readTimeout);
            conn.setRemoteAddress(this._socket.getRemoteSocketAddress());
            ConnectionHandler.FrameOutput<FrameBody> out = new ConnectionHandler.FrameOutput<FrameBody>(conn);
            if (conn.requiresSASL()) {
                ConnectionHandler.FrameOutput<SaslFrameBody> saslOut = new ConnectionHandler.FrameOutput<SaslFrameBody>(conn);
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.HeaderBytesSource(conn, 65, 77, 81, 80, 3, 1, 0, 0), new ConnectionHandler.FrameToBytesSourceAdapter(saslOut.asFrameSource(), conn.getDescribedTypeRegistry()), new ConnectionHandler.HeaderBytesSource(conn, 65, 77, 81, 80, 0, 1, 0, 0), new ConnectionHandler.FrameToBytesSourceAdapter(out.asFrameSource(), conn.getDescribedTypeRegistry()));
                conn.setSaslFrameOutput(saslOut);
            } else {
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.HeaderBytesSource(conn, 65, 77, 81, 80, 0, 1, 0, 0), new ConnectionHandler.FrameToBytesSourceAdapter(out.asFrameSource(), conn.getDescribedTypeRegistry()));
            }
            OutputStream outputStream = this._socket.getOutputStream();
            ConnectionHandler.BytesOutputHandler outputHandler = new ConnectionHandler.BytesOutputHandler(outputStream, src, conn, exceptionHandler);
            long threadIndex = this._threadNameIndex.getAndIncrement();
            Thread outputThread = new Thread((Runnable)outputHandler, "QpidConnectionOutputThread-" + threadIndex);
            outputThread.setDaemon(true);
            outputThread.start();
            conn.setFrameOutputHandler(out);
            final ConnectionHandler handler = new ConnectionHandler(conn);
            final InputStream inputStream = this._socket.getInputStream();
            Thread inputThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TCPTransportProvider.this.doRead(conn, handler, inputStream);
                    }
                    finally {
                        if (conn.closedForInput() && conn.closedForOutput()) {
                            TCPTransportProvider.this.close();
                        }
                    }
                }
            }, "QpidConnectionInputThread-" + threadIndex);
            inputThread.setDaemon(true);
            inputThread.start();
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public void close() {
        try {
            this._socket.close();
        }
        catch (IOException e) {
            RAW_LOGGER.log(Level.WARNING, "Unexpected Error during TCPTransportProvider socket close", e);
        }
    }

    private void doRead(ConnectionEndpoint conn, ConnectionHandler handler, InputStream inputStream) {
        byte[] buf = new byte[65536];
        try {
            boolean done = false;
            long lastReadTime = System.currentTimeMillis();
            while (!handler.isDone()) {
                try {
                    int read = inputStream.read(buf);
                    if (read == -1) break;
                    lastReadTime = System.currentTimeMillis();
                    ByteBuffer bbuf = ByteBuffer.wrap(buf, 0, read);
                    while (bbuf.hasRemaining() && !handler.isDone()) {
                        handler.parse(bbuf);
                    }
                }
                catch (SocketTimeoutException e) {
                    if (this._readIdleTimeout <= -1L || System.currentTimeMillis() - lastReadTime < this._readIdleTimeout) continue;
                    break;
                }
            }
            if (!handler.isDone()) {
                conn.inputClosed();
                if (conn.getConnectionEventListener() != null) {
                    conn.getConnectionEventListener().closeReceived();
                }
            }
        }
        catch (IOException e) {
            conn.inputClosed();
            e.printStackTrace();
        }
    }
}

