/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ChannelsExhaustedException;
import org.apache.qpid.amqp_1_0.client.Connection;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.client.TransactionController;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoder;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.transport.SessionState;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DistributionMode;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.Filter;
import org.apache.qpid.amqp_1_0.type.messaging.Source;
import org.apache.qpid.amqp_1_0.type.messaging.StdDistMode;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.transaction.TxnCapability;
import org.apache.qpid.amqp_1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.SenderSettleMode;

public class Session {
    private SessionEndpoint _endpoint;
    private List<Receiver> _receivers = new ArrayList<Receiver>();
    private List<Sender> _senders = new ArrayList<Sender>();
    private SectionEncoder _sectionEncoder;
    private SectionDecoder _sectionDecoder;
    private TransactionController _sessionLocalTC;
    private Connection _connection;

    public Session(Connection connection, String name) throws ChannelsExhaustedException {
        this._connection = connection;
        this._endpoint = connection.getEndpoint().createSession(name);
        if (this._endpoint == null) {
            throw new ChannelsExhaustedException("Cannot create session as all channels are in use");
        }
        this._sectionEncoder = new SectionEncoderImpl(connection.getEndpoint().getDescribedTypeRegistry());
        this._sectionDecoder = new SectionDecoderImpl(connection.getEndpoint().getDescribedTypeRegistry());
    }

    public Sender createSender(String targetName) throws Sender.SenderCreationException, ConnectionClosedException {
        String sourceName = UUID.randomUUID().toString();
        return new Sender(this, targetName + "<-" + sourceName, targetName, sourceName, false);
    }

    public Sender createSender(String targetName, SourceConfigurator configurator) throws Sender.SenderCreationException, ConnectionClosedException {
        String sourceName = UUID.randomUUID().toString();
        return this.createSender(sourceName, targetName, configurator);
    }

    public Sender createSender(String sourceName, String targetName, final SourceConfigurator configurator) throws Sender.SenderCreationException, ConnectionClosedException {
        return new Sender(this, targetName + "<-" + sourceName, targetName, sourceName, false){

            @Override
            protected void configureSource(Source source) {
                configurator.configureSource(source);
            }
        };
    }

    public Sender createSender(String targetName, int window) throws Sender.SenderCreationException, ConnectionClosedException {
        String sourceName = UUID.randomUUID().toString();
        return new Sender(this, targetName + "<-" + sourceName, targetName, sourceName, window);
    }

    public Sender createSender(String targetName, int window, AcknowledgeMode mode, String linkName) throws Sender.SenderCreationException, ConnectionClosedException {
        return this.createSender(targetName, window, mode, linkName, false, null);
    }

    public Sender createSender(String targetName, int window, AcknowledgeMode mode, String linkName, boolean isDurable, Map<Binary, Outcome> unsettled) throws Sender.SenderCreationException, ConnectionClosedException {
        return new Sender(this, linkName == null ? "->" + targetName + '(' + UUID.randomUUID().toString() + ')' : linkName, targetName, null, window, mode, isDurable, unsettled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendingLinkEndpoint createSendingLinkEndpoint(String linkName, Target target, Source source, AcknowledgeMode mode, Map<Binary, Outcome> unsettled, DeliveryStateHandler deliveryStateHandler) {
        SessionEndpoint endpoint = this.getEndpoint();
        Object object = endpoint.getLock();
        synchronized (object) {
            SendingLinkEndpoint link = endpoint.createSendingLinkEndpoint(linkName, source, target, unsettled, deliveryStateHandler);
            switch (mode) {
                case ALO: {
                    link.setSendingSettlementMode(SenderSettleMode.UNSETTLED);
                    link.setReceivingSettlementMode(ReceiverSettleMode.FIRST);
                    break;
                }
                case AMO: {
                    link.setSendingSettlementMode(SenderSettleMode.SETTLED);
                    break;
                }
                case EO: {
                    link.setSendingSettlementMode(SenderSettleMode.UNSETTLED);
                    link.setReceivingSettlementMode(ReceiverSettleMode.SECOND);
                }
            }
            link.attach();
            return link;
        }
    }

    public Receiver createReceiver(String sourceAddr) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, UUID.randomUUID().toString(), null, AcknowledgeMode.ALO);
    }

    public Receiver createReceiver(String queue, AcknowledgeMode mode) throws ConnectionErrorException {
        return this.createReceiver(queue, UUID.randomUUID().toString(), null, mode);
    }

    public Receiver createReceiver(String queue, AcknowledgeMode mode, String linkName) throws ConnectionErrorException {
        return this.createReceiver(queue, UUID.randomUUID().toString(), null, mode, linkName);
    }

    public Receiver createReceiver(String queue, AcknowledgeMode mode, String linkName, boolean isDurable) throws ConnectionErrorException {
        return this.createReceiver(queue, UUID.randomUUID().toString(), null, mode, linkName, isDurable);
    }

    public Receiver createReceiver(String queue, AcknowledgeMode mode, String linkName, boolean isDurable, Map<Symbol, Filter> filters, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        return this.createReceiver(queue, (DistributionMode)null, mode, linkName, isDurable, filters, unsettled);
    }

    public Receiver createReceiver(String queue, String targetName, AcknowledgeMode mode, String linkName, boolean isDurable, Map<Symbol, Filter> filters, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        return this.createReceiver(queue, targetName, null, mode, linkName, isDurable, filters, unsettled);
    }

    public Receiver createReceiver(String queue, AcknowledgeMode mode, String linkName, boolean isDurable, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        return this.createReceiver(queue, UUID.randomUUID().toString(), null, mode, linkName, isDurable, unsettled);
    }

    private synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, targetAddr, mode, AcknowledgeMode.ALO);
    }

    private synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode, AcknowledgeMode ackMode) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, targetAddr, mode, ackMode, null);
    }

    private synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode, AcknowledgeMode ackMode, String linkName) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, targetAddr, mode, ackMode, linkName, false);
    }

    private synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode, AcknowledgeMode ackMode, String linkName, boolean isDurable) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, targetAddr, mode, ackMode, linkName, isDurable, null);
    }

    private synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode, AcknowledgeMode ackMode, String linkName, boolean isDurable, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, mode, ackMode, linkName, isDurable, null, unsettled);
    }

    public synchronized Receiver createReceiver(String sourceAddr, DistributionMode mode, AcknowledgeMode ackMode, String linkName, boolean isDurable, Map<Symbol, Filter> filters, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, UUID.randomUUID().toString(), mode, ackMode, linkName, isDurable, filters, unsettled);
    }

    public synchronized Receiver createReceiver(String sourceAddr, String targetAddr, DistributionMode mode, AcknowledgeMode ackMode, String linkName, boolean isDurable, Map<Symbol, Filter> filters, Map<Binary, Outcome> unsettled) throws ConnectionErrorException {
        Target target = new Target();
        target.setAddress(targetAddr);
        Source source = new Source();
        source.setAddress(sourceAddr);
        source.setDistributionMode(mode);
        source.setFilter(filters);
        if (linkName == null) {
            linkName = sourceAddr + "-> (" + UUID.randomUUID().toString() + ")";
        }
        Receiver receiver = new Receiver(this, linkName, target, source, ackMode, isDurable, unsettled);
        this._receivers.add(receiver);
        return receiver;
    }

    public synchronized Receiver createCopyingReceiver(String sourceAddr) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, UUID.randomUUID().toString(), StdDistMode.COPY);
    }

    public synchronized Receiver createMovingReceiver(String sourceAddr) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, UUID.randomUUID().toString(), StdDistMode.MOVE);
    }

    public synchronized Receiver createMovingReceiver(String sourceAddr, String targetAddr) throws ConnectionErrorException {
        return this.createReceiver(sourceAddr, UUID.randomUUID().toString(), StdDistMode.MOVE);
    }

    public Receiver createTemporaryQueueReceiver() throws AmqpErrorException, ConnectionErrorException {
        Source source = new Source();
        source.setDynamic(true);
        Receiver receiver = new Receiver(this, "tempSender" + UUID.randomUUID().toString(), new Target(), source, AcknowledgeMode.ALO);
        this._receivers.add(receiver);
        return receiver;
    }

    public Sender createTemporaryQueueSender() throws Sender.SenderCreationException, ConnectionClosedException {
        Target target = new Target();
        target.setDynamic(true);
        Sender sender = new Sender(this, "tempSender" + UUID.randomUUID().toString(), target, new Source(), 0, AcknowledgeMode.ALO);
        this._senders.add(sender);
        return sender;
    }

    public SessionEndpoint getEndpoint() {
        return this._endpoint;
    }

    public synchronized void close() {
        try {
            for (Sender sender : new ArrayList<Sender>(this._senders)) {
                sender.close();
            }
            for (Receiver receiver : new ArrayList<Receiver>(this._receivers)) {
                receiver.detach();
            }
            if (this._sessionLocalTC != null) {
                this._sessionLocalTC.close();
            }
            this._endpoint.end();
        }
        catch (Sender.SenderClosingException e) {
            e.printStackTrace();
        }
    }

    void removeSender(Sender sender) {
        this._senders.remove(sender);
    }

    void removeReceiver(Receiver receiver) {
        this._receivers.remove(receiver);
    }

    public SectionEncoder getSectionEncoder() {
        return this._sectionEncoder;
    }

    public SectionDecoder getSectionDecoder() {
        return this._sectionDecoder;
    }

    public Transaction createSessionLocalTransaction() throws LinkDetachedException {
        TransactionController localController = this.getSessionLocalTransactionController();
        return localController.beginTransaction();
    }

    private TransactionController getSessionLocalTransactionController() {
        if (this._sessionLocalTC == null) {
            this._sessionLocalTC = this.createSessionLocalTransactionController();
        }
        return this._sessionLocalTC;
    }

    private TransactionController createSessionLocalTransactionController() {
        String name = "txnControllerLink";
        SendingLinkEndpoint tcLinkEndpoint = this._endpoint.createTransactionController(name, TxnCapability.LOCAL_TXN, TxnCapability.MULTI_TXNS_PER_SSN);
        tcLinkEndpoint.setReceivingSettlementMode(ReceiverSettleMode.FIRST);
        tcLinkEndpoint.setSendingSettlementMode(SenderSettleMode.UNSETTLED);
        tcLinkEndpoint.attach();
        return new TransactionController(this, tcLinkEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() {
        while (this.getEndpoint().getState() == SessionState.ACTIVE) {
            Object object = this.getEndpoint().getLock();
            synchronized (object) {
                try {
                    for (Receiver r : this._receivers) {
                        Message m = r.receive(false);
                        if (m == null) continue;
                        return m;
                    }
                    this.getEndpoint().getLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Connection getConnection() {
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitActive() {
        Object object = this.getEndpoint().getLock();
        synchronized (object) {
            while (!this.getEndpoint().isEnded() && !this.getEndpoint().isActive()) {
                try {
                    this.getEndpoint().getLock().wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface SourceConfigurator {
        public void configureSource(Source var1);
    }
}

