/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpSequence;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

public class Message {
    private static final Map<Class<? extends Section>, Collection<Class<? extends Section>>> VALID_NEXT_SECTIONS = new HashMap<Class<? extends Section>, Collection<Class<? extends Section>>>();
    private Binary _deliveryTag;
    private List<Section> _payload = new ArrayList<Section>();
    private Boolean _resume;
    private boolean _settled;
    private DeliveryState _deliveryState;
    private Receiver _receiver;

    public Message() {
    }

    public Message(Collection<Section> sections) {
        this(sections, true);
    }

    public Message(Collection<Section> sections, boolean validate) {
        this._payload.addAll(validate ? Message.validateOrReorder(sections) : sections);
    }

    public Message(Section section) {
        this(Collections.singletonList(section));
    }

    public Message(String message) {
        this(new AmqpValue(message));
    }

    private static Collection<Section> validateOrReorder(Collection<Section> providedSections) {
        Collection<Section> validatedSections = providedSections == null ? Collections.emptyList() : (Message.isValidOrder(providedSections) ? providedSections : Message.reorderSections(providedSections));
        return validatedSections;
    }

    private static Collection<Section> reorderSections(Collection<Section> providedSections) {
        ArrayList<Section> validSections = new ArrayList<Section>();
        ArrayList<Section> originalSection = new ArrayList<Section>(providedSections);
        validSections.addAll(Message.getAndRemoveSections(Header.class, originalSection, false));
        validSections.addAll(Message.getAndRemoveSections(DeliveryAnnotations.class, originalSection, false));
        validSections.addAll(Message.getAndRemoveSections(MessageAnnotations.class, originalSection, false));
        validSections.addAll(Message.getAndRemoveSections(Properties.class, originalSection, false));
        validSections.addAll(Message.getAndRemoveSections(ApplicationProperties.class, originalSection, false));
        List<AmqpValue> valueSections = Message.getAndRemoveSections(AmqpValue.class, originalSection, false);
        List<AmqpSequence> sequenceSections = Message.getAndRemoveSections(AmqpSequence.class, originalSection, true);
        List<Data> dataSections = Message.getAndRemoveSections(Data.class, originalSection, true);
        if (valueSections.isEmpty() && sequenceSections.isEmpty() && dataSections.isEmpty()) {
            throw new IllegalArgumentException("Message must contain one of Data, AmqpValue or AmqpSequence");
        }
        if (!((valueSections.isEmpty() || sequenceSections.isEmpty() && dataSections.isEmpty()) && (sequenceSections.isEmpty() || dataSections.isEmpty()))) {
            throw new IllegalArgumentException("Only one type of content Data, AmqpValue or AmqpSequence can be used");
        }
        validSections.addAll(valueSections);
        validSections.addAll(sequenceSections);
        validSections.addAll(dataSections);
        validSections.addAll(Message.getAndRemoveSections(Footer.class, originalSection, false));
        if (!originalSection.isEmpty()) {
            throw new IllegalArgumentException("Invalid section type: " + ((Section)originalSection.get(0)).getClass().getName());
        }
        return validSections;
    }

    private static <T extends Section> List<T> getAndRemoveSections(Class<T> clazz, List<Section> sections, boolean allowMultiple) {
        ArrayList<Section> desiredSections = new ArrayList<Section>();
        ListIterator<Section> iterator = sections.listIterator();
        while (iterator.hasNext()) {
            Section s = iterator.next();
            if (s.getClass() != clazz) continue;
            desiredSections.add(s);
            iterator.remove();
        }
        if (desiredSections.size() > 1 && !allowMultiple) {
            throw new IllegalArgumentException("Multiple " + clazz.getSimpleName() + " sections are not allowed");
        }
        return desiredSections;
    }

    private static boolean isValidOrder(Collection<Section> providedSections) {
        Collection<Class<? extends Section>> validSections;
        Class<?> previousSection = null;
        Iterator<Section> it = providedSections.iterator();
        while (it.hasNext()) {
            validSections = VALID_NEXT_SECTIONS.get(previousSection);
            Section next = it.next();
            Class<?> sectionClass = next.getClass();
            if (validSections == null || !validSections.contains(sectionClass)) {
                return false;
            }
            previousSection = sectionClass;
        }
        validSections = VALID_NEXT_SECTIONS.get(previousSection);
        return validSections != null && validSections.contains(null);
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }

    public void setDeliveryTag(Binary deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    public List<Section> getPayload() {
        return Collections.unmodifiableList(this._payload);
    }

    private <T extends Section> T getSection(Class<T> clazz) {
        for (Section s : this._payload) {
            if (!clazz.isAssignableFrom(s.getClass())) continue;
            return (T)s;
        }
        return null;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.getSection(ApplicationProperties.class);
    }

    public Properties getProperties() {
        return this.getSection(Properties.class);
    }

    public Header getHeader() {
        return this.getSection(Header.class);
    }

    public void setResume(Boolean resume) {
        this._resume = resume;
    }

    public boolean isResume() {
        return Boolean.TRUE.equals(this._resume);
    }

    public void setDeliveryState(DeliveryState state) {
        this._deliveryState = state;
    }

    public DeliveryState getDeliveryState() {
        return this._deliveryState;
    }

    public void setSettled(boolean settled) {
        this._settled = settled;
    }

    public boolean getSettled() {
        return this._settled;
    }

    public void setReceiver(Receiver receiver) {
        this._receiver = receiver;
    }

    public Receiver getReceiver() {
        return this._receiver;
    }

    static {
        VALID_NEXT_SECTIONS.put(null, Arrays.asList(Header.class, DeliveryAnnotations.class, MessageAnnotations.class, Properties.class, ApplicationProperties.class, AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(Header.class, Arrays.asList(DeliveryAnnotations.class, MessageAnnotations.class, Properties.class, ApplicationProperties.class, AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(DeliveryAnnotations.class, Arrays.asList(MessageAnnotations.class, Properties.class, ApplicationProperties.class, AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(MessageAnnotations.class, Arrays.asList(Properties.class, ApplicationProperties.class, AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(Properties.class, Arrays.asList(ApplicationProperties.class, AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(ApplicationProperties.class, Arrays.asList(AmqpValue.class, AmqpSequence.class, Data.class));
        VALID_NEXT_SECTIONS.put(AmqpValue.class, Arrays.asList(Footer.class, null));
        VALID_NEXT_SECTIONS.put(AmqpSequence.class, Arrays.asList(AmqpSequence.class, Footer.class, null));
        VALID_NEXT_SECTIONS.put(Data.class, Arrays.asList(Data.class, Footer.class, null));
        VALID_NEXT_SECTIONS.put(Footer.class, Collections.singletonList(null));
    }
}

