/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubClient;
import com.microsoft.eventhubs.client.EventHubConsumerGroup;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubMessage;
import com.microsoft.eventhubs.client.EventHubOffsetFilter;
import com.microsoft.eventhubs.client.EventHubReceiver;
import com.microsoft.eventhubs.client.IEventHubFilter;
import org.apache.qpid.amqp_1_0.client.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilientEventHubReceiver {
    private static final Logger logger = LoggerFactory.getLogger(EventHubClient.class);
    public static final int RecoveryRetryCount = 3;
    public static final int RecoveryRetryInterval = 1000;
    protected String connectionString;
    protected String eventHubName;
    protected String partitionId;
    protected String consumerGroupName;
    protected int defaultCredits;
    protected IEventHubFilter filter;
    private EventHubClient client;
    private EventHubConsumerGroup consumerGroup;
    private EventHubReceiver receiver;
    protected Message lastMessage;

    public ResilientEventHubReceiver(String connectionString, String eventHubName, String partitionId, String consumerGroupName, int defaultCredits, IEventHubFilter filter) {
        this.connectionString = connectionString;
        this.eventHubName = eventHubName;
        this.partitionId = partitionId;
        this.consumerGroupName = consumerGroupName;
        this.defaultCredits = defaultCredits;
        this.filter = filter;
    }

    public void initialize() throws EventHubException {
        if (this.client == null) {
            this.client = EventHubClient.create(this.connectionString, this.eventHubName);
            this.consumerGroup = this.client.getConsumerGroup(this.consumerGroupName);
            this.receiver = this.consumerGroup.createReceiver(this.partitionId, this.filter, this.defaultCredits);
        }
    }

    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
            this.receiver = null;
        }
        if (this.consumerGroup != null) {
            this.consumerGroup.close();
            this.consumerGroup = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected Message originalReceive(long waitTimeInMilliseconds) {
        return this.receiver.receive(waitTimeInMilliseconds);
    }

    public Message receive(long waitTimeInMilliseconds) {
        Message message = null;
        try {
            long start = System.currentTimeMillis();
            message = this.originalReceive(waitTimeInMilliseconds);
            long end = System.currentTimeMillis();
            long millis = end - start;
            if (message == null) {
                if (waitTimeInMilliseconds > 100L && millis < waitTimeInMilliseconds / 2L) {
                    logger.error("Failed to receive messages in " + millis + " millisecond. Recovering.");
                    throw new Exception();
                }
            } else {
                this.lastMessage = message;
            }
        }
        catch (Exception e) {
            this.recover();
        }
        return message;
    }

    public void recover() {
        int retries;
        if (this.lastMessage != null) {
            EventHubMessage ehMessage = EventHubMessage.parseAmqpMessage(this.lastMessage);
            logger.info("Recovering with offset filter " + ehMessage.getOffset());
            this.filter = new EventHubOffsetFilter(ehMessage.getOffset());
        }
        for (retries = 0; retries < 3; ++retries) {
            this.close();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.initialize();
                break;
            }
            catch (EventHubException e) {
                logger.warn("Failed to recover, current retry " + retries);
                continue;
            }
        }
        if (retries < 3) {
            logger.info("Successfully recovered");
        } else {
            logger.error("Failed to recover");
        }
    }
}

