/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubClient;
import com.microsoft.eventhubs.client.EventHubException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSender {
    private static final Logger logger = LoggerFactory.getLogger(EventHubSender.class);
    private static final int retryCount = 3;
    private static final int retryDelayInMilliseconds = 1000;
    private final String connectionString;
    private final String entityPath;
    private final String partitionId;
    private final String destinationAddress;
    private Session session;
    private Sender sender;
    private boolean shouldRecreateSession;

    @Deprecated
    public EventHubSender(Session session, String entityPath, String partitionId) {
        this.connectionString = null;
        this.session = session;
        this.entityPath = entityPath;
        this.partitionId = partitionId;
        this.destinationAddress = this.getDestinationAddress();
    }

    public EventHubSender(String connectionString, String entityPath, String partitionId) {
        this.connectionString = connectionString;
        this.entityPath = entityPath;
        this.partitionId = partitionId;
        this.destinationAddress = this.getDestinationAddress();
        this.shouldRecreateSession = true;
    }

    public void send(Section section) throws EventHubException {
        Message message = new Message(section);
        this.sendCore(message);
    }

    public void send(byte[] data) throws EventHubException {
        Binary bin = new Binary(data);
        Message message = new Message(new Data(bin));
        this.sendCore(message);
    }

    public void send(String data) throws EventHubException {
        this.send(data.getBytes());
    }

    private void sendCore(Message message) throws EventHubException {
        int retry = 0;
        boolean sendSucceeded = false;
        while (!sendSucceeded) {
            try {
                this.ensureSenderCreated();
                this.sender.send(message);
                sendSucceeded = true;
            }
            catch (Exception e) {
                this.HandleException(e);
                if (++retry <= 3) continue;
                throw new EventHubException("An error occurred while sending data.", e);
            }
        }
    }

    private void HandleException(Exception e) throws EventHubException {
        logger.error(e.getMessage());
        if (e instanceof LinkDetachedException) {
            this.sender = null;
        } else if (e instanceof ConnectionException) {
            this.shouldRecreateSession = true;
            this.sender = null;
        }
    }

    public void close() throws EventHubException {
        try {
            if (this.sender != null && !this.sender.isClosed()) {
                this.sender.close();
            }
        }
        catch (Sender.SenderClosingException e) {
            throw new EventHubException("An error occurred while closing the sender.", e);
        }
    }

    private String getDestinationAddress() {
        if (this.partitionId == null || this.partitionId.equals("")) {
            return this.entityPath;
        }
        return String.format("%s/Partitions/%s", this.entityPath, this.partitionId);
    }

    private synchronized void ensureSenderCreated() throws Exception {
        if (this.sender == null || this.sender.isClosed()) {
            logger.info("Creating EventHubs sender");
            if (this.connectionString != null && this.shouldRecreateSession) {
                this.session = EventHubClient.createConnection(this.connectionString).createSession();
                this.shouldRecreateSession = false;
            }
            this.sender = this.session.createSender(this.destinationAddress);
        }
    }
}

