/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.SelectorFilter;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Filter;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHubReceiver {
    private static final Logger logger = LoggerFactory.getLogger(EventHubReceiver.class);
    private final Session session;
    private final String entityPath;
    private final String consumerGroupName;
    private final String partitionId;
    private final String consumerAddress;
    private final Map<Symbol, Filter> filters;
    private final int defaultCredits;
    private Receiver receiver;
    private boolean isClosed;

    public EventHubReceiver(Session session, String entityPath, String consumerGroupName, String partitionId, String filterStr, int defaultCredits) throws EventHubException {
        this.session = session;
        this.entityPath = entityPath;
        this.consumerGroupName = consumerGroupName;
        this.partitionId = partitionId;
        this.consumerAddress = this.getConsumerAddress();
        this.filters = Collections.singletonMap(Symbol.valueOf("apache.org:selector-filter:string"), new SelectorFilter(filterStr));
        logger.info("receiver filter string: " + filterStr);
        this.defaultCredits = defaultCredits;
        this.ensureReceiverCreated();
    }

    public Message receive(long waitTimeInMilliseconds) {
        this.checkIfClosed();
        Message message = this.receiver.receive(waitTimeInMilliseconds);
        if (message != null) {
            this.receiver.acknowledge(message);
            return message;
        }
        this.checkError();
        return null;
    }

    public void close() {
        if (!this.isClosed) {
            this.receiver.close();
            this.isClosed = true;
        }
    }

    private String getConsumerAddress() {
        return String.format("%s/ConsumerGroups/%s/Partitions/%s", this.entityPath, this.consumerGroupName, this.partitionId);
    }

    private void ensureReceiverCreated() throws EventHubException {
        try {
            logger.info("defaultCredits: " + this.defaultCredits);
            this.receiver = this.session.createReceiver(this.consumerAddress, AcknowledgeMode.ALO, "eventhubs-receiver-link", false, this.filters, null);
            this.receiver.setCredit(UnsignedInteger.valueOf(this.defaultCredits), true);
        }
        catch (ConnectionErrorException e) {
            throw new EventHubException(e);
        }
    }

    private void checkError() {
        Error error = this.receiver.getError();
        if (error != null) {
            String errorMessage = error.toString();
            logger.error(errorMessage);
            this.close();
            throw new RuntimeException(errorMessage);
        }
    }

    private void checkIfClosed() {
        if (this.isClosed) {
            throw new RuntimeException("receiver was closed.");
        }
    }
}

