/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import java.util.Date;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;

public class EventHubMessage {
    private String offset;
    private long sequence;
    private long enqueuedTimestamp;
    private byte[] data;

    public EventHubMessage(String offset, long sequence, long enqueuedTimestamp, byte[] data) {
        this.offset = offset;
        this.sequence = sequence;
        this.enqueuedTimestamp = enqueuedTimestamp;
        this.data = data;
    }

    public static EventHubMessage parseAmqpMessage(Message message) {
        EventHubMessage ehMessage = null;
        if (message != null) {
            String offset = null;
            long sequence = 0L;
            long enqueuedTimestamp = 0L;
            byte[] data = null;
            for (Section section : message.getPayload()) {
                if (section instanceof MessageAnnotations) {
                    Map annotationMap = ((MessageAnnotations)section).getValue();
                    if (annotationMap.containsKey(Symbol.valueOf("x-opt-offset"))) {
                        offset = (String)annotationMap.get(Symbol.valueOf("x-opt-offset"));
                    }
                    if (annotationMap.containsKey(Symbol.valueOf("x-opt-sequence-number"))) {
                        sequence = (Long)annotationMap.get(Symbol.valueOf("x-opt-sequence-number"));
                    }
                    if (!annotationMap.containsKey(Symbol.valueOf("x-opt-enqueued-time"))) continue;
                    enqueuedTimestamp = ((Date)annotationMap.get(Symbol.valueOf("x-opt-enqueued-time"))).getTime();
                    continue;
                }
                if (data == null && section instanceof Data) {
                    data = ((Data)section).getValue().getArray();
                    continue;
                }
                if (data != null || !(section instanceof AmqpValue)) continue;
                data = ((AmqpValue)section).getValue().toString().getBytes();
            }
            ehMessage = new EventHubMessage(offset, sequence, enqueuedTimestamp, data);
        }
        return ehMessage;
    }

    public String getOffset() {
        return this.offset;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getEnqueuedTimestamp() {
        return this.enqueuedTimestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataAsString() {
        if (this.data == null) {
            return "";
        }
        return new String(this.data);
    }
}

