/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class SqlOverlapsOperator
extends SqlSpecialOperator {
    private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("OVERLAPS");

    public SqlOverlapsOperator() {
        super("OVERLAPS", SqlKind.OVERLAPS, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, null);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep(")", true);
        writer.sep(this.getName());
        writer.sep("(", true);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(4);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (4 == operandsCount);
        return "({1}, {2}) {0} ({3}, {4})";
    }

    @Override
    public String getAllowedSignatures(String opName) {
        String d = "DATETIME";
        String i = "INTERVAL";
        String[] typeNames = new String[]{"DATETIME", "DATETIME", "DATETIME", "INTERVAL", "INTERVAL", "DATETIME", "INTERVAL", "INTERVAL"};
        StringBuilder ret = new StringBuilder();
        for (int y = 0; y < typeNames.length; y += 2) {
            if (y > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of((Object)"DATETIME", (Object)typeNames[y], (Object)"DATETIME", (Object)typeNames[y + 1])));
        }
        return ret.toString();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCall call = callBinding.getCall();
        SqlValidator validator = callBinding.getValidator();
        SqlValidatorScope scope = callBinding.getScope();
        if (!OperandTypes.DATETIME.checkSingleOperandType(callBinding, (SqlNode)call.operand(0), 0, throwOnFailure)) {
            return false;
        }
        if (!OperandTypes.DATETIME.checkSingleOperandType(callBinding, (SqlNode)call.operand(2), 0, throwOnFailure)) {
            return false;
        }
        RelDataType t0 = validator.deriveType(scope, (SqlNode)call.operand(0));
        RelDataType t1 = validator.deriveType(scope, (SqlNode)call.operand(1));
        RelDataType t2 = validator.deriveType(scope, (SqlNode)call.operand(2));
        RelDataType t3 = validator.deriveType(scope, (SqlNode)call.operand(3));
        if (!SqlTypeUtil.sameNamedType(t0, t2)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        if (SqlTypeUtil.isDatetime(t1)) {
            if (!SqlTypeUtil.sameNamedType(t0, t1)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        } else if (!SqlTypeUtil.isInterval(t1)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        if (SqlTypeUtil.isDatetime(t3)) {
            if (!SqlTypeUtil.sameNamedType(t2, t3)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        } else if (!SqlTypeUtil.isInterval(t3)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }
}

