/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public abstract class SqlCall
extends SqlNode {
    public SqlCall(SqlParserPos pos) {
        super(pos);
    }

    public boolean isExpanded() {
        return false;
    }

    public void setOperand(int i, SqlNode operand) {
        throw new UnsupportedOperationException();
    }

    public abstract SqlOperator getOperator();

    public abstract List<SqlNode> getOperandList();

    public <S extends SqlNode> S operand(int i) {
        return (S)this.getOperandList().get(i);
    }

    public int operandCount() {
        return this.getOperandList().size();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(pos, this.getOperandList());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlOperator operator = this.getOperator();
        if (leftPrec > operator.getLeftPrec() || operator.getRightPrec() <= rightPrec && rightPrec != 0 || writer.isAlwaysUseParentheses() && this.isA(SqlKind.EXPRESSION)) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            operator.unparse(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            operator.unparse(writer, this, leftPrec, rightPrec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateCall(this, scope);
    }

    @Override
    public void findValidOptions(SqlValidator validator, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        for (SqlNode operand : this.getOperandList()) {
            SqlIdentifier id;
            SqlParserPos idPos;
            if (!(operand instanceof SqlIdentifier) || !(idPos = (id = (SqlIdentifier)operand).getParserPosition()).toString().equals(pos.toString())) continue;
            ((SqlValidatorImpl)validator).lookupNameCompletionHints(scope, (List<String>)id.names, pos, hintList);
            return;
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (node == this) {
            return true;
        }
        if (!(node instanceof SqlCall)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlCall that = (SqlCall)node;
        if (!this.getOperator().getName().equals(that.getOperator().getName())) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return SqlCall.equalDeep(this.getOperandList(), that.getOperandList(), fail);
    }

    protected String getCallSignature(SqlValidator validator, SqlValidatorScope scope) {
        ArrayList<String> signatureList = new ArrayList<String>();
        for (SqlNode operand : this.getOperandList()) {
            RelDataType argType = validator.deriveType(scope, operand);
            if (null == argType) continue;
            signatureList.add(argType.toString());
        }
        return SqlUtil.getOperatorSignature(this.getOperator(), signatureList);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        SqlCallBinding binding = new SqlCallBinding(scope.getValidator(), scope, this);
        return this.getOperator().getMonotonicity(binding);
    }

    public boolean isCountStar() {
        SqlIdentifier id;
        Object parm;
        return this.getOperator().isName("COUNT") && this.operandCount() == 1 && (parm = this.operand(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)parm).isStar() && id.names.size() == 1;
    }

    public SqlLiteral getFunctionQuantifier() {
        return null;
    }
}

