/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;

public class JoinPushExpressionsRule
extends RelOptRule {
    public static final JoinPushExpressionsRule INSTANCE = new JoinPushExpressionsRule(Join.class, RelFactories.DEFAULT_PROJECT_FACTORY);
    private final RelFactories.ProjectFactory projectFactory;

    public JoinPushExpressionsRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        super(JoinPushExpressionsRule.operand(clazz, JoinPushExpressionsRule.any()));
        this.projectFactory = projectFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelNode newJoin = RelOptUtil.pushDownJoinConditions(join, this.projectFactory);
        if (newJoin instanceof Join) {
            RexNode newCondition = ((Join)newJoin).getCondition();
            if (join.getCondition().toString().equals(newCondition.toString())) {
                return;
            }
        }
        call.transformTo(newJoin);
    }
}

