/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.model.JsonCustomSchema;
import org.apache.calcite.model.JsonCustomTable;
import org.apache.calcite.model.JsonFunction;
import org.apache.calcite.model.JsonJdbcSchema;
import org.apache.calcite.model.JsonLattice;
import org.apache.calcite.model.JsonMapSchema;
import org.apache.calcite.model.JsonMaterialization;
import org.apache.calcite.model.JsonMeasure;
import org.apache.calcite.model.JsonRoot;
import org.apache.calcite.model.JsonSchema;
import org.apache.calcite.model.JsonTile;
import org.apache.calcite.model.JsonView;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.schema.impl.TableMacroImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Stacks;
import org.apache.calcite.util.Util;

public class ModelHandler {
    private final CalciteConnection connection;
    private final List<Pair<String, SchemaPlus>> schemaStack = new ArrayList<Pair<String, SchemaPlus>>();
    private final String modelUri;
    Lattice.Builder latticeBuilder;
    Lattice.TileBuilder tileBuilder;

    public ModelHandler(CalciteConnection connection, String uri) throws IOException {
        this.connection = connection;
        this.modelUri = uri;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JsonRoot root = uri.startsWith("inline:") ? (JsonRoot)mapper.readValue(uri.substring("inline:".length()), JsonRoot.class) : (JsonRoot)mapper.readValue(new File(uri), JsonRoot.class);
        this.visit(root);
    }

    public static void create(SchemaPlus schema, String functionName, List<String> path, String className, String methodName) {
        AggregateFunctionImpl aggFunction;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("UDF class '" + className + "' not found");
        }
        TableFunction tableFunction = TableFunctionImpl.create(clazz);
        if (tableFunction != null) {
            schema.add(functionName, tableFunction);
            return;
        }
        TableMacro macro = TableMacroImpl.create(clazz);
        if (macro != null) {
            schema.add(functionName, macro);
            return;
        }
        if (methodName != null && methodName.equals("*")) {
            for (Map.Entry entry : ScalarFunctionImpl.createAll(clazz).entries()) {
                schema.add((String)entry.getKey(), (Function)entry.getValue());
            }
            return;
        }
        ScalarFunction function = ScalarFunctionImpl.create(clazz, Util.first(methodName, "eval"));
        if (function != null) {
            schema.add(Util.first(functionName, methodName), function);
            return;
        }
        if (methodName == null && (aggFunction = AggregateFunctionImpl.create(clazz)) != null) {
            schema.add(functionName, aggFunction);
            return;
        }
        throw new RuntimeException("Not a valid function class: " + clazz + ". Scalar functions and table macros have an 'eval' method; " + "aggregate functions have 'init' and 'add' methods, and optionally " + "'initAdd', 'merge' and 'result' methods.");
    }

    public void visit(JsonRoot root) {
        Pair<Object, SchemaPlus> pair = Pair.of(null, this.connection.getRootSchema());
        Stacks.push(this.schemaStack, pair);
        for (JsonSchema schema : root.schemas) {
            schema.accept(this);
        }
        Stacks.pop(this.schemaStack, pair);
        if (root.defaultSchema != null) {
            try {
                this.connection.setSchema(root.defaultSchema);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void visit(JsonMapSchema jsonSchema) {
        SchemaPlus parentSchema = this.currentMutableSchema("schema");
        SchemaPlus schema = parentSchema.add(jsonSchema.name, new AbstractSchema());
        if (jsonSchema.path != null) {
            schema.setPath(ModelHandler.stringListList(jsonSchema.path));
        }
        this.populateSchema(jsonSchema, schema);
    }

    private static ImmutableList<ImmutableList<String>> stringListList(List path) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object s : path) {
            builder.add(ModelHandler.stringList(s));
        }
        return builder.build();
    }

    private static ImmutableList<String> stringList(Object s) {
        if (s instanceof String) {
            return ImmutableList.of((Object)((String)s));
        }
        if (s instanceof List) {
            ImmutableList.Builder builder2 = ImmutableList.builder();
            for (Object o : (List)s) {
                if (o instanceof String) {
                    builder2.add((Object)((String)o));
                    continue;
                }
                throw new RuntimeException("Invalid path element " + o + "; was expecting string");
            }
            return builder2.build();
        }
        throw new RuntimeException("Invalid path element " + s + "; was expecting string or list of string");
    }

    private void populateSchema(JsonSchema jsonSchema, SchemaPlus schema) {
        boolean cache = jsonSchema.cache == null || jsonSchema.cache != false;
        schema.setCacheEnabled(cache);
        Pair<String, SchemaPlus> pair = Pair.of(jsonSchema.name, schema);
        Stacks.push(this.schemaStack, pair);
        jsonSchema.visitChildren(this);
        Stacks.pop(this.schemaStack, pair);
    }

    public void visit(JsonCustomSchema jsonSchema) {
        try {
            SchemaPlus parentSchema = this.currentMutableSchema("sub-schema");
            Class<?> clazz = Class.forName(jsonSchema.factory);
            SchemaFactory schemaFactory = (SchemaFactory)clazz.newInstance();
            Schema schema = schemaFactory.create(parentSchema, jsonSchema.name, this.operandMap(jsonSchema.operand));
            SchemaPlus schemaPlus = parentSchema.add(jsonSchema.name, schema);
            this.populateSchema(jsonSchema, schemaPlus);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonSchema, e);
        }
    }

    protected Map<String, Object> operandMap(Map<String, Object> operand) {
        if (operand == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(operand);
        block4: for (ExtraOperand extraOperand : ExtraOperand.values()) {
            if (operand.containsKey(extraOperand.camelName)) continue;
            switch (extraOperand) {
                case MODEL_URI: {
                    builder.put((Object)extraOperand.camelName, (Object)this.modelUri);
                    continue block4;
                }
                case BASE_DIRECTORY: {
                    if (this.modelUri.startsWith("inline:")) continue block4;
                    File file = new File(this.modelUri);
                    builder.put((Object)extraOperand.camelName, (Object)file.getParentFile());
                }
            }
        }
        return builder.build();
    }

    public void visit(JsonJdbcSchema jsonSchema) {
        SchemaPlus parentSchema = this.currentMutableSchema("jdbc schema");
        DataSource dataSource = JdbcSchema.dataSource(jsonSchema.jdbcUrl, jsonSchema.jdbcDriver, jsonSchema.jdbcUser, jsonSchema.jdbcPassword);
        JdbcSchema schema = JdbcSchema.create(parentSchema, jsonSchema.name, dataSource, jsonSchema.jdbcCatalog, jsonSchema.jdbcSchema);
        SchemaPlus schemaPlus = parentSchema.add(jsonSchema.name, schema);
        this.populateSchema(jsonSchema, schemaPlus);
    }

    public void visit(JsonMaterialization jsonMaterialization) {
        try {
            boolean existing;
            String viewName;
            SchemaPlus schema = this.currentSchema();
            if (!schema.isMutable()) {
                throw new RuntimeException("Cannot define materialization; parent schema '" + this.currentSchemaName() + "' is not a SemiMutableSchema");
            }
            CalciteSchema calciteSchema = CalciteSchema.from(schema);
            if (jsonMaterialization.view == null) {
                viewName = "$" + schema.getTableNames().size();
                existing = true;
            } else {
                viewName = jsonMaterialization.view;
                existing = false;
            }
            schema.add(viewName, MaterializedViewTable.create(calciteSchema, jsonMaterialization.getSql(), null, jsonMaterialization.table, existing));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonMaterialization, e);
        }
    }

    public void visit(JsonLattice jsonLattice) {
        try {
            SchemaPlus schema = this.currentSchema();
            if (!schema.isMutable()) {
                throw new RuntimeException("Cannot define lattice; parent schema '" + this.currentSchemaName() + "' is not a SemiMutableSchema");
            }
            CalciteSchema calciteSchema = CalciteSchema.from(schema);
            Lattice.Builder latticeBuilder = Lattice.builder(calciteSchema, jsonLattice.getSql()).auto(jsonLattice.auto).algorithm(jsonLattice.algorithm);
            if (jsonLattice.rowCountEstimate != null) {
                latticeBuilder.rowCountEstimate(jsonLattice.rowCountEstimate);
            }
            if (jsonLattice.statisticProvider != null) {
                latticeBuilder.statisticProvider(jsonLattice.statisticProvider);
            }
            this.populateLattice(jsonLattice, latticeBuilder);
            schema.add(jsonLattice.name, latticeBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonLattice, e);
        }
    }

    private void populateLattice(JsonLattice jsonLattice, Lattice.Builder latticeBuilder) {
        if (jsonLattice.defaultMeasures == null) {
            JsonMeasure countMeasure = new JsonMeasure();
            countMeasure.agg = "count";
            jsonLattice.defaultMeasures = ImmutableList.of((Object)countMeasure);
        }
        assert (this.latticeBuilder == null);
        this.latticeBuilder = latticeBuilder;
        jsonLattice.visitChildren(this);
        this.latticeBuilder = null;
    }

    public void visit(JsonCustomTable jsonTable) {
        try {
            SchemaPlus schema = this.currentMutableSchema("table");
            Class<?> clazz = Class.forName(jsonTable.factory);
            TableFactory tableFactory = (TableFactory)clazz.newInstance();
            Object table = tableFactory.create(schema, jsonTable.name, this.operandMap(jsonTable.operand), null);
            schema.add(jsonTable.name, (Table)table);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonTable, e);
        }
    }

    public void visit(JsonView jsonView) {
        try {
            SchemaPlus schema = this.currentMutableSchema("view");
            List<String> path = Util.first(jsonView.path, this.currentSchemaPath());
            schema.add(jsonView.name, ViewTable.viewMacro(schema, jsonView.getSql(), path, jsonView.modifiable));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonView, e);
        }
    }

    private List<String> currentSchemaPath() {
        return Collections.singletonList(Stacks.peek(this.schemaStack).left);
    }

    private SchemaPlus currentSchema() {
        return (SchemaPlus)Stacks.peek(this.schemaStack).right;
    }

    private String currentSchemaName() {
        return (String)Stacks.peek(this.schemaStack).left;
    }

    private SchemaPlus currentMutableSchema(String elementType) {
        SchemaPlus schema = this.currentSchema();
        if (!schema.isMutable()) {
            throw new RuntimeException("Cannot define " + elementType + "; parent schema '" + schema.getName() + "' is not mutable");
        }
        return schema;
    }

    public void visit(JsonFunction jsonFunction) {
        try {
            SchemaPlus schema = this.currentMutableSchema("function");
            List<String> path = Util.first(jsonFunction.path, this.currentSchemaPath());
            ModelHandler.create(schema, jsonFunction.name, path, jsonFunction.className, jsonFunction.methodName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonFunction, e);
        }
    }

    public void visit(JsonMeasure jsonMeasure) {
        assert (this.latticeBuilder != null);
        Lattice.Measure measure = this.latticeBuilder.resolveMeasure(jsonMeasure.agg, jsonMeasure.args);
        if (this.tileBuilder != null) {
            this.tileBuilder.addMeasure(measure);
        } else if (this.latticeBuilder != null) {
            this.latticeBuilder.addMeasure(measure);
        } else {
            throw new AssertionError((Object)"nowhere to put measure");
        }
    }

    public void visit(JsonTile jsonTile) {
        assert (this.tileBuilder == null);
        this.tileBuilder = Lattice.Tile.builder();
        for (JsonMeasure jsonMeasure : jsonTile.measures) {
            jsonMeasure.accept(this);
        }
        for (JsonMeasure dimension : jsonTile.dimensions) {
            Lattice.Column column = this.latticeBuilder.resolveColumn(dimension);
            this.tileBuilder.addDimension(column);
        }
        this.latticeBuilder.addTile(this.tileBuilder.build());
        this.tileBuilder = null;
    }

    public static enum ExtraOperand {
        MODEL_URI("modelUri"),
        BASE_DIRECTORY("baseDirectory");

        public final String camelName;

        private ExtraOperand(String camelName) {
            this.camelName = camelName;
        }
    }
}

